/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.entry;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryBase;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryInterface;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import org.w3c.dom.Node;

public class ScheduleEntryCopy {
    private ScheduleEntryInterface entry = null;

    public ScheduleEntryCopy(Node entryNode, Connection ctxConnection, Job job, String scheduleName) throws ETLXMLException {
        try {
            String stype = XMLHandler.getTagValue(entryNode, "type");
            int type = ScheduleEntryCopy.getType(stype);
            this.entry = ScheduleEntryBase.newScheduleEntryInterface(type);
            if (this.entry != null) {
                this.entry.loadXML(entryNode, ctxConnection, job, scheduleName);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read Job Entry copy info from XML node", e);
        }
    }

    public ScheduleEntryInterface getEntry() {
        return this.entry;
    }

    public static final int getType(String dsc) {
        int i;
        if (dsc != null) {
            for (i = 0; i < ScheduleEntryInterface.type_desc.length; ++i) {
                if (!ScheduleEntryInterface.type_desc[i].equalsIgnoreCase(dsc)) continue;
                return i;
            }
        }
        if (dsc != null) {
            for (i = 0; i < ScheduleEntryInterface.type_desc_long.length; ++i) {
                if (!ScheduleEntryInterface.type_desc_long[i].equalsIgnoreCase(dsc)) continue;
                return i;
            }
        }
        return 0;
    }

    public ScheduleEntryCopy(LogWriter log, Repository rep, long id_schedule, Job job) throws ETLException {
        long id_schedule_type = rep.getScheduleTypeID(id_schedule);
        Row rt = rep.getScheduleType(id_schedule_type);
        if (rt == null) {
            throw new ETLException("Unable to find Schedule Entry Type with id=" + id_schedule_type + " in the repository");
        }
        String set_code = rt.searchValue("Code").getString();
        int set_type = ScheduleEntryBase.getType(set_code);
        this.entry = ScheduleEntryBase.newScheduleEntryInterface(set_type);
        this.entry.loadRep(rep, id_schedule, job);
    }
}

