/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server;

import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.JobLog;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.schedule.Schedule;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigCopy;
import com.kingdee.bos.ctrl.etl.server.config.ServerConfigInterface;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServerMeta {
    private String name = "";
    private String configFilename = "";
    private Connection ctxConnection = null;
    private List databases;
    private LogWriter log;
    private ServerConfigCopy sc = null;

    public ServerMeta(LogWriter log, Connection ctxConnection) throws ETLXMLException {
        this.ctxConnection = ctxConnection;
        String xml = "<Server><name>eas_etl_server</name><Config><type>rep</type><user>admin</user><password>admin</password><repname>eas_rep</repname><repdesc>eas_rep</repdesc></Config></Server>";
        this.log = log;
        try {
            Document doc = XMLHandler.loadXMLString(xml);
            if (doc == null) {
                throw new ETLXMLException("Error reading/validating information from XML file: " + this.configFilename);
            }
            this.clear();
            Node serverNode = XMLHandler.getSubNode(doc, "server");
            this.loadXML(log, serverNode, ctxConnection);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load the server from XML file: [" + this.configFilename + "]", e);
        }
    }

    public ServerMeta(LogWriter log, String configFilename, Connection ctxConnection) throws ETLXMLException {
        this.ctxConnection = ctxConnection;
        this.log = log;
        this.configFilename = configFilename;
        try {
            Document doc = XMLHandler.loadXMLFile(configFilename);
            if (doc == null) {
                throw new ETLXMLException("Error reading/validating information from XML file: " + configFilename);
            }
            this.clear();
            Node serverNode = XMLHandler.getSubNode(doc, "server");
            this.loadXML(log, serverNode, ctxConnection);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load the server from XML file: [" + configFilename + "]", e);
        }
    }

    public void refresh() throws ETLXMLException {
        try {
            Document doc = XMLHandler.loadXMLFile(this.configFilename);
            if (doc == null) {
                throw new ETLXMLException("Error reading/validating information from XML file: " + this.configFilename);
            }
            this.clear();
            Node serverNode = XMLHandler.getSubNode(doc, "server");
            this.loadXML(this.log, serverNode, this.ctxConnection);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load the server from XML file: [" + this.configFilename + "]", e);
        }
    }

    public String getName() {
        return this.name;
    }

    private void loadXML(LogWriter log, Node serverNode, Connection ctxConnection) throws ETLXMLException {
        try {
            this.ctxConnection = ctxConnection;
            this.name = XMLHandler.getTagValue(serverNode, "name");
            int nr = XMLHandler.countNodes(serverNode, "connection");
            for (int i = 0; i < nr; ++i) {
                Node dbnode = XMLHandler.getSubNodeByNr(serverNode, "connection", i);
                DatabaseMeta dbinf = new DatabaseMeta(dbnode);
                this.addDatabase(dbinf);
            }
            if (ctxConnection != null) {
                DatabaseMeta dbinf = new DatabaseMeta(ctxConnection);
                this.addDatabase(dbinf);
            }
            Node configNode = XMLHandler.getSubNode(serverNode, "config");
            this.sc = new ServerConfigCopy(log, configNode, this.databases, ctxConnection);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load job info from XML node", e);
        }
    }

    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
    }

    public void updateSchedule(Schedule schedule) {
        if (this.sc == null) {
            return;
        }
        ServerConfigInterface si = this.sc.getEntry();
        si.updateSchedule(schedule);
    }

    public void updateJob(Job job) {
        if (this.sc == null) {
            return;
        }
        ServerConfigInterface si = this.sc.getEntry();
        si.updateJob(job);
    }

    public void removeSchedule(String scheduleName) {
        ServerConfigInterface si = this.sc.getEntry();
        si.removeSchedule(scheduleName);
    }

    public List getSchedules() {
        if (this.sc == null) {
            return null;
        }
        ServerConfigInterface si = this.sc.getEntry();
        return si.getSchedules();
    }

    public List getLogAudits() {
        ArrayList logaudits = new ArrayList();
        List jobs = this.getJobs();
        for (Job job : jobs) {
            JobLog joblog = job.getJoblog();
            List audits = null;
            try {
                audits = joblog.getJobAudit();
            }
            catch (ETLDatabaseException e) {
                e.printStackTrace();
            }
            if (audits == null) continue;
            logaudits.addAll(audits);
        }
        return logaudits;
    }

    public List getLogErrors() {
        ArrayList logerrors = new ArrayList();
        List jobs = this.getJobs();
        for (Job job : jobs) {
            JobLog joblog = job.getJoblog();
            List errors = null;
            try {
                errors = joblog.getJobError();
            }
            catch (ETLDatabaseException e) {
                e.printStackTrace();
            }
            if (errors == null) continue;
            logerrors.addAll(errors);
        }
        return logerrors;
    }

    public Repository getRepository() {
        if (this.sc == null) {
            return null;
        }
        ServerConfigInterface si = this.sc.getEntry();
        return si.getRepository();
    }

    public List getJobs() {
        if (this.sc == null) {
            return null;
        }
        ServerConfigInterface si = this.sc.getEntry();
        return si.getJobs();
    }

    public Job findJob(long id_job) {
        List jobs = this.getJobs();
        if (jobs == null) {
            return null;
        }
        for (Job item : jobs) {
            if (id_job != item.getID()) continue;
            return item;
        }
        return null;
    }

    private void clear() {
        this.databases = new ArrayList();
    }

    public Connection getConnection() {
        return this.ctxConnection;
    }
}

