/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.exception.ETLStepLoaderException;
import com.kingdee.bos.ctrl.etl.transformation.StepPlugin;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StepLoader {
    private static StepLoader stepLoader = null;
    private String[] pluginDirectory;
    private ArrayList pluginList;
    private Hashtable classLoaders;

    private StepLoader(String[] pluginDirectory) {
        this.pluginDirectory = pluginDirectory;
        this.pluginList = new ArrayList();
        this.classLoaders = new Hashtable();
    }

    public static final StepLoader getInstance(String[] pluginDirectory) {
        if (stepLoader != null) {
            return stepLoader;
        }
        stepLoader = new StepLoader(pluginDirectory);
        return stepLoader;
    }

    public static final StepLoader getInstance() {
        if (stepLoader != null) {
            return stepLoader;
        }
        stepLoader = new StepLoader(new String[]{Const.PLUGIN_STEPS_DIRECTORY_PUBLIC, Const.PLUGIN_STEPS_DIRECTORY_PRIVATE});
        return stepLoader;
    }

    public boolean read() {
        if (this.readNatives()) {
            return this.readPlugins();
        }
        return false;
    }

    public boolean readNatives() {
        for (int i = 1; i < BaseStep.type_desc.length; ++i) {
            String id = BaseStep.type_desc[i];
            String long_desc = BaseStep.type_long_desc[i];
            String tooltip = BaseStep.type_tooltip_desc[i];
            String iconfile = "/be/ibridge/kettle/images/" + BaseStep.image_filename[i];
            String classname = BaseStep.type_classname[i].getName();
            String directory = null;
            String[] jarfiles = null;
            String category = BaseStep.category[i];
            StepPlugin sp = new StepPlugin(1, id, long_desc, tooltip, directory, jarfiles, iconfile, classname, category, null);
            if (id.equalsIgnoreCase("ScriptValues")) {
                sp.setSeparateClassloaderNeeded(true);
            }
            this.pluginList.add(sp);
        }
        return true;
    }

    public boolean readPlugins() {
        for (int dirNr = 0; dirNr < this.pluginDirectory.length; ++dirNr) {
            try {
                File f = new File(FilenameUtils.normalize((String)this.pluginDirectory[dirNr]));
                if (!f.isDirectory() || !f.exists()) continue;
                LogWriter log = LogWriter.getInstance();
                log.logDetailed("StepLoader", "Looking for plugins in directory: " + this.pluginDirectory[dirNr]);
                String[] dirs = f.list();
                for (int i = 0; i < dirs.length; ++i) {
                    String pixml;
                    File fpixml;
                    String piDir = this.pluginDirectory[dirNr] + Const.FILE_SEPARATOR + dirs[i];
                    File pi = new File(FilenameUtils.normalize((String)piDir));
                    if (!pi.isDirectory() || !(fpixml = new File(pixml = pi.toString() + Const.FILE_SEPARATOR + "plugin.xml")).canRead()) continue;
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(fpixml);
                        Node plugin = XMLHandler.getSubNode(doc, "plugin");
                        String id = XMLHandler.getTagAttribute(plugin, "id");
                        String description = XMLHandler.getTagAttribute(plugin, "description");
                        String iconfile = XMLHandler.getTagAttribute(plugin, "iconfile");
                        String tooltip = XMLHandler.getTagAttribute(plugin, "tooltip");
                        String category = XMLHandler.getTagAttribute(plugin, "category");
                        String classname = XMLHandler.getTagAttribute(plugin, "classname");
                        String errorHelpfile = XMLHandler.getTagAttribute(plugin, "errorhelpfile");
                        Node libsnode = XMLHandler.getSubNode(plugin, "libraries");
                        int nrlibs = XMLHandler.countNodes(libsnode, "library");
                        String[] jarfiles = new String[nrlibs];
                        for (int j = 0; j < nrlibs; ++j) {
                            Node libnode = XMLHandler.getSubNodeByNr(libsnode, "library", j);
                            String jarfile = XMLHandler.getTagAttribute(libnode, "name");
                            jarfiles[j] = pi.toString() + Const.FILE_SEPARATOR + jarfile;
                        }
                        String iconFilename = pi.toString() + Const.FILE_SEPARATOR + iconfile;
                        StepPlugin sp = new StepPlugin(2, id, description, tooltip, dirs[i], jarfiles, iconFilename, classname, category, pi.getPath() + Const.FILE_SEPARATOR + errorHelpfile);
                        if (this.findStepPluginWithID(id) == null) {
                            this.pluginList.add(sp);
                            continue;
                        }
                        int idx = this.pluginList.indexOf(sp);
                        this.pluginList.set(idx, sp);
                        continue;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public StepMetaInterface getStepClass(String desc) throws ETLStepLoaderException {
        StepPlugin sp = this.findStepPluginWithDescription(desc);
        if (sp != null) {
            return this.getStepClass(sp);
        }
        throw new ETLStepLoaderException("Unable to load class for step/plugin with description [" + desc + "]." + Const.CR + "Check if the plugin is available in the plugins subdirectory of the ETL distribution.");
    }

    public StepMetaInterface getStepClass(StepPlugin sp) throws ETLStepLoaderException {
        if (sp != null) {
            try {
                Class<?> cl = null;
                switch (sp.getType()) {
                    case 1: {
                        cl = Class.forName(sp.getClassname());
                        break;
                    }
                    case 2: {
                        String[] jarfiles = sp.getJarfiles();
                        URL[] urls = new URL[jarfiles.length];
                        for (int i = 0; i < jarfiles.length; ++i) {
                            File jarfile = new File(jarfiles[i]);
                            urls[i] = jarfile.toURL();
                        }
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        URLClassLoader ucl = null;
                        if (sp.isSeparateClassloaderNeeded()) {
                            ucl = new URLClassLoader(urls, classLoader);
                        } else {
                            ucl = (URLClassLoader)this.classLoaders.get(sp.getID());
                            if (ucl == null) {
                                ucl = new URLClassLoader(urls, classLoader);
                                this.classLoaders.put(sp.getID(), ucl);
                            }
                        }
                        cl = ucl.loadClass(sp.getClassname());
                        break;
                    }
                    default: {
                        throw new ETLStepLoaderException("Unknown plugin type : " + sp.getType());
                    }
                }
                return (StepMetaInterface)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ETLStepLoaderException("Class not found", e);
            }
            catch (InstantiationException e) {
                throw new ETLStepLoaderException("Unable to instantiate class", e);
            }
            catch (IllegalAccessException e) {
                throw new ETLStepLoaderException("Illegal access to class", e);
            }
            catch (MalformedURLException e) {
                throw new ETLStepLoaderException("Malformed URL", e);
            }
            catch (Throwable e) {
                throw new ETLStepLoaderException("Unexpected error loading class", e);
            }
        }
        throw new ETLStepLoaderException("No valid step/plugin specified.");
    }

    public int nrStepsWithType(int type) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = (StepPlugin)this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            ++nr;
        }
        return nr;
    }

    public StepPlugin getStepWithType(int type, int position) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = (StepPlugin)this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            if (nr == position) {
                return sp;
            }
            ++nr;
        }
        return null;
    }

    public StepPlugin[] getStepsWithType(int type) {
        int nr = this.nrStepsWithType(type);
        StepPlugin[] steps = new StepPlugin[nr];
        for (int i = 0; i < steps.length; ++i) {
            StepPlugin sp;
            steps[i] = sp = this.getStepWithType(type, i);
        }
        return steps;
    }

    public StepPlugin findStepPluginWithID(String stepid) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = (StepPlugin)this.pluginList.get(i);
            if (!sp.getID().equalsIgnoreCase(stepid)) continue;
            return sp;
        }
        return null;
    }

    public StepPlugin findStepPluginWithDescription(String description) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = (StepPlugin)this.pluginList.get(i);
            if (!sp.getDescription().equalsIgnoreCase(description)) continue;
            return sp;
        }
        return null;
    }

    public String[] getCategories(int type) {
        Hashtable<String, String> cat = new Hashtable<String, String>();
        for (int i = 0; i < this.nrStepsWithType(type); ++i) {
            StepPlugin sp = this.getStepWithType(type, i);
            if (sp == null) continue;
            cat.put(sp.getCategory(), sp.getCategory());
        }
        Enumeration keys = cat.keys();
        String[] retval = new String[cat.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            retval[i] = (String)keys.nextElement();
            ++i;
        }
        for (int a = 0; a < retval.length; ++a) {
            for (int b = 0; b < retval.length - 1; ++b) {
                int idx2;
                int idx1 = Const.indexOfString(retval[b], BaseStep.category_order);
                if (idx1 <= (idx2 = Const.indexOfString(retval[b + 1], BaseStep.category_order))) continue;
                String dummy = retval[b];
                retval[b] = retval[b + 1];
                retval[b + 1] = dummy;
            }
        }
        return retval;
    }

    public int nrStepsWithCategory(String category) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = (StepPlugin)this.pluginList.get(i);
            if (!sp.getCategory().equalsIgnoreCase(category)) continue;
            ++nr;
        }
        return nr;
    }

    public StepPlugin getStepWithCategory(String category, int position) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            StepPlugin sp = (StepPlugin)this.pluginList.get(i);
            if (!sp.getCategory().equalsIgnoreCase(category)) continue;
            if (nr == position) {
                return sp;
            }
            ++nr;
        }
        return null;
    }

    public StepPlugin[] getStepsWithCategory(String category) {
        int nr = this.nrStepsWithCategory(category);
        StepPlugin[] steps = new StepPlugin[nr];
        for (int i = 0; i < steps.length; ++i) {
            StepPlugin sp;
            steps[i] = sp = this.getStepWithCategory(category, i);
        }
        return steps;
    }

    public String getStepPluginID(StepMetaInterface sii) {
        for (int i = 0; i < this.nrStepsWithType(0); ++i) {
            StepPlugin sp = this.getStepWithType(0, i);
            if (sp.getClassname() != sii.getClass().getName()) continue;
            return sp.getID();
        }
        return null;
    }
}

