/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.databasejoin;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.DatabaseImpact;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.databasejoin.DatabaseJoin;
import com.kingdee.bos.ctrl.etl.transformation.step.databasejoin.DatabaseJoinData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class DatabaseJoinMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String sql;
    private int rowLimit;
    private boolean outerJoin;
    private String[] parameterField;
    private int[] parameterType;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] parameterField) {
        this.parameterField = parameterField;
    }

    public int[] getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int[] parameterType) {
        this.parameterType = parameterType;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.parameterField = null;
        this.parameterType = null;
        this.outerJoin = false;
        this.readData(stepnode, databases);
    }

    public void allocate(int nrparam) {
        this.parameterField = new String[nrparam];
        this.parameterType = new int[nrparam];
    }

    @Override
    public Object clone() {
        DatabaseJoinMeta retval = (DatabaseJoinMeta)super.clone();
        int nrparam = this.parameterField.length;
        retval.allocate(nrparam);
        for (int i = 0; i < nrparam; ++i) {
            retval.parameterField[i] = this.parameterField[i];
            retval.parameterType[i] = this.parameterType[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.databaseMeta = Const.findDatabase(databases, con);
            this.sql = XMLHandler.getTagValue(stepnode, "sql");
            this.outerJoin = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "outer_join"));
            this.rowLimit = Const.toInt(XMLHandler.getTagValue(stepnode, "rowlimit"), 0);
            Node param = XMLHandler.getSubNode(stepnode, "parameter");
            int nrparam = XMLHandler.countNodes(param, "field");
            this.allocate(nrparam);
            for (int i = 0; i < nrparam; ++i) {
                Node pnode = XMLHandler.getSubNodeByNr(param, "field", i);
                this.parameterField[i] = XMLHandler.getTagValue(pnode, "name");
                String ptype = XMLHandler.getTagValue(pnode, "type");
                this.parameterType[i] = Value.getType(ptype);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.parameterField = null;
        this.parameterType = null;
        this.outerJoin = false;
        int nrparam = 0;
        this.allocate(nrparam);
        for (int i = 0; i < nrparam; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterType[i] = 1;
        }
    }

    public Row getParameterRow(Row fields) {
        Row param = new Row();
        for (int i = 0; i < this.parameterField.length; ++i) {
            Value v = fields.searchValue(this.parameterField[i]);
            if (v == null) continue;
            param.addValue(v);
        }
        return param;
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Row row = r == null ? new Row() : r;
        if (this.databaseMeta == null) {
            return row;
        }
        Database db = new Database(this.databaseMeta);
        this.databases = new Database[]{db};
        Row param = this.getParameterRow(info);
        Row add = null;
        try {
            add = db.getQueryFields(this.sql, true, param);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLStepException("Unable to determine the fields of query:" + Const.CR + this.sql, dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                Value v = add.getValue(i);
                v.setOrigin(name);
            }
            row.addRow(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(this.sql, true, param);
                if (add == null) {
                    return row;
                }
                for (int i = 0; i < add.size(); ++i) {
                    Value v = add.getValue(i);
                    v.setOrigin(name);
                }
                row.addRow(add);
                db.disconnect();
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLStepException("Error obtaining fields for this step", dbe);
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("connection", this.databaseMeta == null ? "" : this.databaseMeta.getName());
        retval = retval + "    " + XMLHandler.addTagValue("rowlimit", this.rowLimit);
        retval = retval + "    " + XMLHandler.addTagValue("sql", this.sql);
        retval = retval + "    " + XMLHandler.addTagValue("outer_join", this.outerJoin);
        retval = retval + "    <parameter>" + Const.CR;
        for (int i = 0; i < this.parameterField.length; ++i) {
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.parameterField[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.parameterType[i]));
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </parameter>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = Const.findDatabase(databases, id_connection);
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "rowlimit");
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.outerJoin = rep.getStepAttributeBoolean(id_step, "outer_join");
            int nrparam = rep.countNrStepAttributes(id_step, "parameter_field");
            this.allocate(nrparam);
            for (int i = 0; i < nrparam; ++i) {
                this.parameterField[i] = rep.getStepAttributeString(id_step, i, "parameter_field");
                String stype = rep.getStepAttributeString(id_step, i, "parameter_type");
                this.parameterType[i] = Value.getType(stype);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "rowlimit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "outer_join", this.outerJoin);
            for (int i = 0; i < this.parameterField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "parameter_field", this.parameterField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "parameter_type", Value.getTypeDesc(this.parameterType[i]));
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql != null && this.sql.length() != 0) {
                    Row param = this.getParameterRow(prev);
                    error_message = "";
                    Row r = db.getQueryFields(this.sql, true, param);
                    if (r != null) {
                        cr = new CheckResult(1, "The query is specified and working correctly.", stepinfo);
                        remarks.add(cr);
                    } else {
                        error_message = "Couldn't verify the database query: check the log for more info!";
                        cr = new CheckResult(4, error_message, stepinfo);
                        remarks.add(cr);
                    }
                    int q = db.countParameters(this.sql);
                    if (q != this.parameterField.length) {
                        error_message = "The number of parameters and the number of question marks is different." + Const.CR;
                        error_message = error_message + "\t\tThe number of question marks = " + q + Const.CR;
                        error_message = error_message + "\t\tThe number of parameters     = " + this.parameterField.length;
                        cr = new CheckResult(4, error_message, stepinfo);
                        remarks.add(cr);
                    } else {
                        cr = new CheckResult(1, "The number of parameters is correct. (" + q + ")", stepinfo);
                        remarks.add(cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    boolean first = true;
                    error_message = "";
                    boolean error_found = false;
                    for (int i = 0; i < this.parameterField.length; ++i) {
                        Value v = prev.searchValue(this.parameterField[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + "Missing fields, not found in input from previous steps:" + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.parameterField[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All fields found in the input stream.", stepinfo);
                    remarks.add(cr);
                }
                error_message = "Couldn't read fields from the previous step." + Const.CR;
                cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
            catch (ETLException e) {
                error_message = "An error occurred: " + e.getMessage();
                cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = "Please select or create a connection!";
            cr = new CheckResult(4, error_message, stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row getTableFields() {
        LogWriter log = LogWriter.getInstance();
        Row param = new Row();
        for (int i = 0; i < this.parameterField.length; ++i) {
            param.addValue(new Value(this.parameterField[i], this.parameterType[i]));
        }
        Row fields = null;
        if (this.databaseMeta != null) {
            Database db = new Database(this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                fields = db.getQueryFields(this.sql, true, param);
            }
            catch (ETLDatabaseException dbe) {
                log.logError(this.toString(), "A database error occurred: " + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new DatabaseJoin(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DatabaseJoinData();
    }

    @Override
    public void analyseImpact(List impact, TransMeta transMeta, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) throws ETLStepException {
        Row out = this.getFields(null, stepinfo.getName(), info);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                Value outvalue = out.getValue(i);
                DatabaseImpact di = new DatabaseImpact(1, transMeta.getName(), stepinfo.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), stepinfo.getName(), this.sql, "read from one or more database tables via SQL statement");
                impact.add(di);
            }
        }
    }
}

