/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.excelinput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.excelinput.ExcelInput;
import com.kingdee.bos.ctrl.etl.transformation.step.excelinput.ExcelInputData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Node;

public class ExcelInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] type_trim_desc = new String[]{"none", "left", "right", "both"};
    public static final String STRING_SEPARATOR = " \t --> ";
    private String[] fileName;
    private String[] fileMask;
    private String fileField;
    private String[] sheetName;
    private int[] startRow;
    private int[] startColumn;
    private String sheetField;
    private boolean startsWithHeader;
    private boolean stopOnEmpty;
    private boolean ignoreEmptyRows;
    private String rowNumberField;
    private long rowLimit;
    private String[] fieldName;
    private int[] fieldType;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private int[] fieldTrimType;
    private boolean[] fieldRepeat;

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public boolean[] getFieldRepeat() {
        return this.fieldRepeat;
    }

    public void setFieldRepeat(boolean[] fieldRepeat) {
        this.fieldRepeat = fieldRepeat;
    }

    public int[] getFieldTrimType() {
        return this.fieldTrimType;
    }

    public void setFieldTrimType(int[] fieldTrimType) {
        this.fieldTrimType = fieldTrimType;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String getFileField() {
        return this.fileField;
    }

    public void setFileField(String fileField) {
        this.fileField = fileField;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public boolean ignoreEmptyRows() {
        return this.ignoreEmptyRows;
    }

    public void setIgnoreEmptyRows(boolean ignoreEmptyRows) {
        this.ignoreEmptyRows = ignoreEmptyRows;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getSheetField() {
        return this.sheetField;
    }

    public void setSheetField(String sheetField) {
        this.sheetField = sheetField;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public int[] getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int[] startColumn) {
        this.startColumn = startColumn;
    }

    public int[] getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int[] startRow) {
        this.startRow = startRow;
    }

    public boolean startsWithHeader() {
        return this.startsWithHeader;
    }

    public void setStartsWithHeader(boolean startsWithHeader) {
        this.startsWithHeader = startsWithHeader;
    }

    public boolean stopOnEmpty() {
        return this.stopOnEmpty;
    }

    public void setStopOnEmpty(boolean stopOnEmpty) {
        this.stopOnEmpty = stopOnEmpty;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        ExcelInputMeta retval = (ExcelInputMeta)super.clone();
        int nrfiles = this.fileName.length;
        int nrsheets = this.sheetName.length;
        int nrfields = this.fieldName.length;
        retval.allocate(nrfiles, nrsheets, nrfields);
        for (i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldLength[i] = this.fieldLength[i];
            retval.fieldPrecision[i] = this.fieldPrecision[i];
            retval.fieldTrimType[i] = this.fieldTrimType[i];
            retval.fieldRepeat[i] = this.fieldRepeat[i];
        }
        for (i = 0; i < nrfiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
        }
        for (i = 0; i < nrsheets; ++i) {
            retval.sheetName[i] = this.sheetName[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            int i;
            this.startsWithHeader = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "header"));
            String nempty = XMLHandler.getTagValue(stepnode, "noempty");
            this.ignoreEmptyRows = "Y".equalsIgnoreCase(nempty) || nempty == null;
            String soempty = XMLHandler.getTagValue(stepnode, "stoponempty");
            this.stopOnEmpty = "Y".equalsIgnoreCase(soempty) || nempty == null;
            this.rowNumberField = XMLHandler.getTagValue(stepnode, "rownum_field");
            this.rowNumberField = XMLHandler.getTagValue(stepnode, "rownumfield");
            this.rowLimit = Const.toLong(XMLHandler.getTagValue(stepnode, "limit"), 0L);
            this.sheetField = XMLHandler.getTagValue(stepnode, "sheetfield");
            this.fileField = XMLHandler.getTagValue(stepnode, "filefield");
            Node filenode = XMLHandler.getSubNode(stepnode, "file");
            Node sheetsnode = XMLHandler.getSubNode(stepnode, "sheets");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfiles = XMLHandler.countNodes(filenode, "name");
            int nrsheets = XMLHandler.countNodes(sheetsnode, "sheet");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfiles, nrsheets, nrfields);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr(filenode, "name", i);
                Node filemasknode = XMLHandler.getSubNodeByNr(filenode, "filemask", i);
                this.fileName[i] = XMLHandler.getNodeValue(filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue(filemasknode);
            }
            for (i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldType[i] = Value.getType(XMLHandler.getTagValue(fnode, "type"));
                this.fieldLength[i] = Const.toInt(XMLHandler.getTagValue(fnode, "length"), -1);
                this.fieldPrecision[i] = Const.toInt(XMLHandler.getTagValue(fnode, "precision"), -1);
                String srepeat = XMLHandler.getTagValue(fnode, "repeat");
                this.fieldTrimType[i] = ExcelInputMeta.getTrimType(XMLHandler.getTagValue(fnode, "trim_type"));
                this.fieldRepeat[i] = srepeat != null ? "Y".equalsIgnoreCase(srepeat) : false;
            }
            for (i = 0; i < nrsheets; ++i) {
                Node snode = XMLHandler.getSubNodeByNr(sheetsnode, "sheet", i);
                this.sheetName[i] = XMLHandler.getTagValue(snode, "name");
                this.startRow[i] = Const.toInt(XMLHandler.getTagValue(snode, "startrow"), 0);
                this.startColumn[i] = Const.toInt(XMLHandler.getTagValue(snode, "startcol"), 0);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read step information from XML", e);
        }
    }

    public void allocate(int nrfiles, int nrsheets, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.sheetName = new String[nrsheets];
        this.startRow = new int[nrsheets];
        this.startColumn = new int[nrsheets];
        this.fieldName = new String[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.fieldTrimType = new int[nrfields];
        this.fieldRepeat = new boolean[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.startsWithHeader = true;
        this.ignoreEmptyRows = true;
        this.rowNumberField = "";
        int nrfiles = 0;
        int nrfields = 0;
        int nrsheets = 0;
        this.allocate(nrfiles, nrsheets, nrfields);
        for (i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
        for (i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 1;
            this.fieldLength[i] = 9;
            this.fieldPrecision[i] = 2;
            this.fieldTrimType[i] = 0;
            this.fieldRepeat[i] = false;
        }
        this.rowLimit = 0L;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.fieldName.length; ++i) {
            int type = this.fieldType[i];
            if (type == 0) {
                type = 2;
            }
            Value v = new Value(this.fieldName[i], type);
            v.setLength(this.fieldLength[i], this.fieldPrecision[i]);
            v.setOrigin(name);
            row.addValue(v);
        }
        if (this.fileField != null && this.fileField.length() > 0) {
            Value v = new Value(this.fileField, 2);
            v.setLength(250, -1);
            v.setOrigin(name);
            row.addValue(v);
        }
        if (this.sheetField != null && this.sheetField.length() > 0) {
            Value v = new Value(this.sheetField, 2);
            v.setLength(250, -1);
            v.setOrigin(name);
            row.addValue(v);
        }
        if (this.rowNumberField != null && this.rowNumberField.length() > 0) {
            Value v = new Value(this.rowNumberField, 1);
            v.setLength(7, 0);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("header", this.startsWithHeader);
        retval = retval + "    " + XMLHandler.addTagValue("noempty", this.ignoreEmptyRows);
        retval = retval + "    " + XMLHandler.addTagValue("stoponempty", this.stopOnEmpty);
        retval = retval + "    " + XMLHandler.addTagValue("filefield", this.fileField);
        retval = retval + "    " + XMLHandler.addTagValue("sheetfield", this.sheetField);
        retval = retval + "    " + XMLHandler.addTagValue("rownumfield", this.rowNumberField);
        retval = retval + "    " + XMLHandler.addTagValue("sheetfield", this.sheetField);
        retval = retval + "    " + XMLHandler.addTagValue("filefield", this.fileField);
        retval = retval + "    " + XMLHandler.addTagValue("limit", this.rowLimit);
        retval = retval + "    <file>" + Const.CR;
        for (i = 0; i < this.fileName.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue("name", this.fileName[i]);
            retval = retval + "      " + XMLHandler.addTagValue("filemask", this.fileMask[i]);
        }
        retval = retval + "      </file>" + Const.CR;
        retval = retval + "    <fields>" + Const.CR;
        for (i = 0; i < this.fieldName.length; ++i) {
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.fieldType[i]));
            retval = retval + "        " + XMLHandler.addTagValue("length", this.fieldLength[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.fieldPrecision[i]);
            retval = retval + "        " + XMLHandler.addTagValue("trim_type", ExcelInputMeta.getTrimTypeDesc(this.fieldTrimType[i]));
            retval = retval + "        " + XMLHandler.addTagValue("repeat", this.fieldRepeat[i]);
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "    <sheets>" + Const.CR;
        for (i = 0; i < this.sheetName.length; ++i) {
            retval = retval + "      <sheet>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.sheetName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("startrow", this.startRow[i]);
            retval = retval + "        " + XMLHandler.addTagValue("startcol", this.startColumn[i]);
            retval = retval + "        </sheet>" + Const.CR;
        }
        retval = retval + "      </sheets>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            this.startsWithHeader = rep.getStepAttributeBoolean(id_step, "header");
            this.ignoreEmptyRows = rep.getStepAttributeBoolean(id_step, "noempty");
            this.stopOnEmpty = rep.getStepAttributeBoolean(id_step, "stoponempty");
            this.fileField = rep.getStepAttributeString(id_step, "filefield");
            this.sheetField = rep.getStepAttributeString(id_step, "sheetfield");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownumfield");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrsheets = rep.countNrStepAttributes(id_step, "sheet_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfiles, nrsheets, nrfields);
            for (i = 0; i < nrfiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
            for (i = 0; i < nrsheets; ++i) {
                this.sheetName[i] = rep.getStepAttributeString(id_step, i, "sheet_name");
                this.startRow[i] = (int)rep.getStepAttributeInteger(id_step, i, "sheet_startrow");
                this.startColumn[i] = (int)rep.getStepAttributeInteger(id_step, i, "sheet_startcol");
            }
            for (i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = Value.getType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.fieldTrimType[i] = ExcelInputMeta.getTrimType(rep.getStepAttributeString(id_step, i, "field_trim_type"));
                this.fieldRepeat[i] = rep.getStepAttributeBoolean(id_step, i, "field_repeat");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "header", this.startsWithHeader);
            rep.saveStepAttribute(id_transformation, id_step, "noempty", this.ignoreEmptyRows);
            rep.saveStepAttribute(id_transformation, id_step, "stoponempty", this.stopOnEmpty);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.fileField);
            rep.saveStepAttribute(id_transformation, id_step, "sheetfield", this.sheetField);
            rep.saveStepAttribute(id_transformation, id_step, "rownumfield", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_mask", this.fileMask[i]);
            }
            for (i = 0; i < this.sheetName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "sheet_name", this.sheetName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "sheet_startrow", this.startRow[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "sheet_startcol", this.startColumn[i]);
            }
            for (i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", Value.getTypeDesc(this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", ExcelInputMeta.getTrimTypeDesc(this.fieldTrimType[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", this.fieldRepeat[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    public static final int getTrimType(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < type_trim_desc.length; ++i) {
            if (!type_trim_desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= type_trim_desc.length) {
            return type_trim_desc[0];
        }
        return type_trim_desc[i];
    }

    public String[] getFiles() {
        Object files = null;
        String[] realfile = Const.replEnv(this.fileName);
        String[] realmask = Const.replEnv(this.fileMask);
        ArrayList<String> filelist = new ArrayList<String>();
        for (int i = 0; i < realfile.length; ++i) {
            String onefile = realfile[i];
            final String onemask = realmask[i];
            if (onemask != null && onemask.length() > 0) {
                File file = new File(FilenameUtils.normalize((String)onefile));
                try {
                    files = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(onemask, name);
                        }
                    });
                    for (int j = 0; j < ((String[])files).length; ++j) {
                        files[j] = !onefile.endsWith(Const.FILE_SEPARATOR) ? onefile + Const.FILE_SEPARATOR + files[j] : onefile + files[j];
                    }
                }
                catch (Exception e) {
                    files = null;
                }
            } else {
                String tempPath = FilenameUtils.normalize((String)onefile);
                File file = new File(tempPath);
                files = file.exists() && file.isFile() && file.canRead() ? new String[]{tempPath} : null;
            }
            if (files == null) continue;
            for (int x = 0; x < ((String[])files).length; ++x) {
                filelist.add(files[x]);
            }
        }
        Collections.sort(filelist);
        files = filelist.toArray(new String[filelist.size()]);
        return files;
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, "This step is not expecting nor reading any input", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Not receiving any input from other steps.", stepinfo);
            remarks.add(cr);
        }
        String[] files = this.getFiles();
        if (files == null || files.length == 0) {
            cr = new CheckResult(4, "No files can be found to read.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "This step is reading " + files.length + " files.", stepinfo);
            remarks.add(cr);
        }
    }

    public Row getEmptyFields() {
        Row row = new Row();
        for (int i = 0; i < this.fieldName.length; ++i) {
            Value v = new Value(this.fieldName[i], this.fieldType[i]);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExcelInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExcelInputData();
    }
}

