/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter.FieldSplitter;
import com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter.FieldSplitterData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class FieldSplitterMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String splitField;
    private String delimiter;
    private String[] field;
    private String[] fieldID;
    private boolean[] removeID;
    private int[] fieldType;
    private String[] fieldFormat;
    private String[] fieldGroup;
    private String[] fieldDecimal;
    private String[] fieldCurrency;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private String[] fieldDefault;

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String[] getField() {
        return this.field;
    }

    public void setField(String[] field) {
        this.field = field;
    }

    public String[] getFieldCurrency() {
        return this.fieldCurrency;
    }

    public void setFieldCurrency(String[] fieldCurrency) {
        this.fieldCurrency = fieldCurrency;
    }

    public String[] getFieldDecimal() {
        return this.fieldDecimal;
    }

    public void setFieldDecimal(String[] fieldDecimal) {
        this.fieldDecimal = fieldDecimal;
    }

    public String[] getFieldDefault() {
        return this.fieldDefault;
    }

    public void setFieldDefault(String[] fieldDefault) {
        this.fieldDefault = fieldDefault;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String[] getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(String[] fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public String[] getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String[] fieldID) {
        this.fieldID = fieldID;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public boolean[] removeID() {
        return this.removeID;
    }

    public void setRemoveID(boolean[] removeID) {
        this.removeID = removeID;
    }

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.field = new String[nrfields];
        this.fieldID = new String[nrfields];
        this.removeID = new boolean[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldGroup = new String[nrfields];
        this.fieldDecimal = new String[nrfields];
        this.fieldCurrency = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.fieldDefault = new String[nrfields];
    }

    @Override
    public Object clone() {
        FieldSplitterMeta retval = (FieldSplitterMeta)super.clone();
        int nrfields = this.field.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.field[i] = this.field[i];
            retval.fieldID[i] = this.fieldID[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.fieldGroup[i] = this.fieldGroup[i];
            retval.fieldDecimal[i] = this.fieldDecimal[i];
            retval.fieldCurrency[i] = this.fieldCurrency[i];
            retval.fieldDefault[i] = this.fieldDefault[i];
            retval.removeID[i] = this.removeID[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldLength[i] = this.fieldLength[i];
            retval.fieldPrecision[i] = this.fieldPrecision[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.splitField = XMLHandler.getTagValue(stepnode, "splitfield");
            this.delimiter = XMLHandler.getTagValue(stepnode, "delimiter");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.field[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldID[i] = XMLHandler.getTagValue(fnode, "id");
                String sidrem = XMLHandler.getTagValue(fnode, "idrem");
                String stype = XMLHandler.getTagValue(fnode, "type");
                this.fieldFormat[i] = XMLHandler.getTagValue(fnode, "format");
                this.fieldGroup[i] = XMLHandler.getTagValue(fnode, "group");
                this.fieldDecimal[i] = XMLHandler.getTagValue(fnode, "decimal");
                this.fieldCurrency[i] = XMLHandler.getTagValue(fnode, "currency");
                String slen = XMLHandler.getTagValue(fnode, "length");
                String sprc = XMLHandler.getTagValue(fnode, "precision");
                this.fieldDefault[i] = XMLHandler.getTagValue(fnode, "nullif");
                this.removeID[i] = "Y".equalsIgnoreCase(sidrem);
                this.fieldType[i] = Value.getType(stype);
                this.fieldLength[i] = Const.toInt(slen, -1);
                this.fieldPrecision[i] = Const.toInt(sprc, -1);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.splitField = "";
        this.delimiter = ",";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.field[i] = "field" + i;
            this.fieldID[i] = "id" + i;
            this.removeID[i] = true;
            this.fieldType[i] = 1;
            this.fieldFormat[i] = "";
            this.fieldGroup[i] = "";
            this.fieldDecimal[i] = "";
            this.fieldCurrency[i] = "";
            this.fieldLength[i] = -1;
            this.fieldPrecision[i] = -1;
            this.fieldDefault[i] = "";
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row;
        if (r == null) {
            row = new Row();
        } else {
            row = r;
            int idx = row.searchValueIndex(this.splitField);
            if (idx >= 0) {
                row.removeValue(idx);
            }
            for (int i = 0; i < this.field.length; ++i) {
                Value v = new Value(this.field[i], this.fieldType[i]);
                v.setLength(this.fieldLength[i], this.fieldPrecision[i]);
                v.setOrigin(name);
                if (idx >= row.size()) {
                    row.addValue(v);
                    continue;
                }
                row.addValue(idx + i, v);
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "   " + XMLHandler.addTagValue("splitfield", this.splitField);
        retval = retval + "   " + XMLHandler.addTagValue("delimiter", this.delimiter);
        retval = retval + "    <fields>";
        for (int i = 0; i < this.field.length; ++i) {
            retval = retval + "      <field>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.field[i]);
            retval = retval + "        " + XMLHandler.addTagValue("id", this.fieldID[i]);
            retval = retval + "        " + XMLHandler.addTagValue("idrem", this.removeID[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.fieldType[i]));
            retval = retval + "        " + XMLHandler.addTagValue("format", this.fieldFormat[i]);
            retval = retval + "        " + XMLHandler.addTagValue("group", this.fieldGroup[i]);
            retval = retval + "        " + XMLHandler.addTagValue("decimal", this.fieldDecimal[i]);
            retval = retval + "        " + XMLHandler.addTagValue("length", this.fieldLength[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.fieldPrecision[i]);
            retval = retval + "        " + XMLHandler.addTagValue("nullif", this.fieldDefault[i]);
            retval = retval + "        </field>";
        }
        retval = retval + "      </fields>";
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.splitField = rep.getStepAttributeString(id_step, "splitfield");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.field[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldID[i] = rep.getStepAttributeString(id_step, i, "field_id");
                this.removeID[i] = rep.getStepAttributeBoolean(id_step, i, "field_idrem");
                this.fieldType[i] = Value.getType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.fieldGroup[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.fieldDecimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.fieldDefault[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "splitfield", this.splitField);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            for (int i = 0; i < this.field.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.field[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_id", this.fieldID[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_idrem", this.removeID[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", Value.getTypeDesc(this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", this.fieldGroup[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", this.fieldDecimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_nullif", this.fieldDefault[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
            remarks.add(cr);
            error_message = "";
            Value v = prev.searchValue(this.splitField);
            if (v == null) {
                error_message = "Field to split [" + this.splitField + "] is not present in the input stream!";
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "Splitfield [" + this.splitField + "]found in the input stream.", stepMeta);
                remarks.add(cr);
            }
        } else {
            error_message = "Couldn't read fields from the previous step." + Const.CR;
            cr = new CheckResult(4, error_message, stepMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new FieldSplitter(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FieldSplitterData();
    }
}

