/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.filterrows;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.filterrows.FilterRowsData;
import com.kingdee.bos.ctrl.etl.transformation.step.filterrows.FilterRowsMeta;

public class FilterRows
extends BaseStep
implements StepInterface {
    private FilterRowsMeta meta;
    private FilterRowsData data;

    public FilterRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized boolean keepRow(Row row) {
        this.debug = "before evaluate condition";
        boolean ret = this.meta.getCondition().evaluate(row);
        this.debug = "after evaluate condition";
        return ret;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (FilterRowsMeta)smi;
        this.data = (FilterRowsData)sdi;
        Row r = null;
        r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        boolean keep = this.keepRow(r);
        if (!this.meta.chosesTargetSteps()) {
            if (keep) {
                this.putRow(r);
            }
        } else if (keep) {
            this.putRowTo(r, this.meta.getSendTrueStepname());
        } else {
            this.putRowTo(r, this.meta.getSendFalseStepname());
        }
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FilterRowsMeta)smi;
        this.data = (FilterRowsData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getSendTrueStepname() != null ^ this.meta.getSendFalseStepname() != null) {
                this.logError("Both the 'true' and the 'false' steps need to be supplied, or neither");
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

