/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.flattener;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.flattener.FlattenerData;
import com.kingdee.bos.ctrl.etl.transformation.step.flattener.FlattenerMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class Flattener
extends BaseStep
implements StepInterface {
    private FlattenerMeta meta = (FlattenerMeta)this.getStepMeta().getStepMetaInterface();
    private FlattenerData data;

    public Flattener(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (FlattenerData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.debug = "processRow";
        Row r = this.getRow();
        if (r == null) {
            if (this.data.processed > 0) {
                this.data.previousRow.removeValue(this.data.fieldNr);
                this.data.previousRow.addRow(this.data.targetResult);
                this.putRow(this.data.previousRow);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.fieldNr = r.searchValueIndex(this.meta.getFieldName());
            if (this.data.fieldNr < 0) {
                this.logError("field [" + this.meta.getFieldName() + "] couldn't be found!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.targetRow = new Row();
            Value flattenValue = r.getValue(this.data.fieldNr);
            for (int i = 0; i < this.meta.getTargetField().length; ++i) {
                Value v = new Value(this.meta.getTargetField()[i], flattenValue.getType());
                v.setLength(flattenValue.getLength());
                v.setPrecision(flattenValue.getPrecision());
                v.setNull();
                this.data.targetRow.addValue(v);
            }
            this.data.targetResult = new Row(this.data.targetRow);
            this.first = false;
        }
        Value flat = r.getValue(this.data.fieldNr);
        this.data.targetResult.getValue(this.data.processed).setValue(flat);
        ++this.data.processed;
        if (this.data.processed >= this.meta.getTargetField().length) {
            r.removeValue(this.data.fieldNr);
            r.addRow(this.data.targetResult);
            this.putRow(r);
            this.data.targetResult = new Row(this.data.targetRow);
            this.data.processed = 0;
        }
        this.data.previousRow = r;
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FlattenerMeta)smi;
        this.data = (FlattenerData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

