/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.mapping;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mapping.MappingData;
import com.kingdee.bos.ctrl.etl.transformation.step.mapping.MappingMeta;
import com.kingdee.bos.ctrl.etl.util.LogWriter;

public class Mapping
extends BaseStep
implements StepInterface {
    private MappingMeta meta;
    private MappingData data;

    public Mapping(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (MappingMeta)smi;
        this.data = (MappingData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.data.mappingInput.setOutputDone();
            this.data.mappingInput.setFinished();
            return false;
        }
        this.data.mappingInput.putRow(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingMeta)smi;
        this.data = (MappingData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getMappingTransMeta() != null) {
                LogWriter log = LogWriter.getInstance();
                this.data.trans = new Trans(log, this.meta.getMappingTransMeta());
                this.data.trans.execute(this.getTrans().getTransMeta().getArguments());
                this.data.mappingInput = this.data.trans.findMappingInput();
                if (this.data.mappingInput == null) {
                    this.logError("Couldn't find MappingInput step in the mapping.");
                    return false;
                }
                this.data.mappingOutput = this.data.trans.findMappingOutput();
                if (this.data.mappingOutput == null) {
                    this.logError("Couldn't find MappingOutput step in the mapping.");
                    return false;
                }
                this.data.mappingOutput.setConnectorStep(this);
                this.data.mappingOutput.setOutputField(this.meta.getOutputField());
                this.data.mappingOutput.setOutputMapping(this.meta.getOutputMapping());
            }
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
            if (this.data.trans != null) {
                this.data.trans.waitUntilFinished();
                this.data.trans.endProcessing("end");
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

