/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.mapping;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mapping.Mapping;
import com.kingdee.bos.ctrl.etl.transformation.step.mapping.MappingData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class MappingMeta
extends BaseStepMeta
implements StepMetaInterface {
    private TransMeta mappingTransMeta;
    private String transName;
    private String fileName;
    private String directoryPath;
    private String[] inputField;
    private String[] inputMapping;
    private String[] outputField;
    private String[] outputMapping;

    public TransMeta getMappingTransMeta() {
        return this.mappingTransMeta;
    }

    public void setMappingTransMeta(TransMeta mappingTransMeta) {
        this.mappingTransMeta = mappingTransMeta;
    }

    public String[] getInputField() {
        return this.inputField;
    }

    public void setInputField(String[] inputField) {
        this.inputField = inputField;
    }

    public String[] getInputMapping() {
        return this.inputMapping;
    }

    public void setInputMapping(String[] mappingField) {
        this.inputMapping = mappingField;
    }

    public String[] getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String[] outputField) {
        this.outputField = outputField;
    }

    public String[] getOutputMapping() {
        return this.outputMapping;
    }

    public void setOutputMapping(String[] outputRename) {
        this.outputMapping = outputRename;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        try {
            this.readData(stepnode);
        }
        catch (ETLException e) {
            throw new ETLXMLException("Error loading transformation step from XML", e);
        }
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws ETLException {
        int i;
        this.transName = XMLHandler.getTagValue(stepnode, "trans_name");
        this.fileName = XMLHandler.getTagValue(stepnode, "filename");
        this.directoryPath = XMLHandler.getTagValue(stepnode, "directory_path");
        Node inputNode = XMLHandler.getSubNode(stepnode, "input");
        Node outputNode = XMLHandler.getSubNode(stepnode, "output");
        int nrInput = XMLHandler.countNodes(inputNode, "field");
        int nrOutput = XMLHandler.countNodes(outputNode, "field");
        this.allocate(nrInput, nrOutput);
        for (i = 0; i < nrInput; ++i) {
            Node inputConnector = XMLHandler.getSubNodeByNr(inputNode, "connector", i);
            this.inputField[i] = XMLHandler.getTagValue(inputConnector, "field");
            this.inputMapping[i] = XMLHandler.getTagValue(inputConnector, "mapping");
        }
        for (i = 0; i < nrOutput; ++i) {
            Node outputConnector = XMLHandler.getSubNodeByNr(outputNode, "connector", i);
            this.outputField[i] = XMLHandler.getTagValue(outputConnector, "field");
            this.outputMapping[i] = XMLHandler.getTagValue(outputConnector, "mapping");
        }
        this.loadMappingMeta(null);
    }

    public void allocate(int nrInput, int nrOutput) {
        this.inputField = new String[nrInput];
        this.inputMapping = new String[nrInput];
        this.outputField = new String[nrOutput];
        this.outputMapping = new String[nrOutput];
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        if (this.mappingTransMeta != null) {
            retval = retval + "    " + XMLHandler.addTagValue("trans_name", this.mappingTransMeta.getName());
            if (this.mappingTransMeta.getDirectory() != null) {
                retval = retval + "    " + XMLHandler.addTagValue("directory_path", this.mappingTransMeta.getDirectory().getPath());
            }
            if (this.mappingTransMeta.getFilename() != null) {
                retval = retval + "    " + XMLHandler.addTagValue("filename", this.mappingTransMeta.getFilename());
            }
        }
        retval = retval + "  <input>" + Const.CR;
        for (i = 0; i < this.inputField.length; ++i) {
            retval = retval + "    <connector>" + XMLHandler.addTagValue("field", this.inputField[i], false) + "  " + XMLHandler.addTagValue("mapping", this.inputMapping[i], false) + "</connector>" + Const.CR;
        }
        retval = retval + "    </input>" + Const.CR;
        retval = retval + "  <output>" + Const.CR;
        for (i = 0; i < this.inputField.length; ++i) {
            retval = retval + "    <connector>" + XMLHandler.addTagValue("field", this.outputField[i], false) + "  " + XMLHandler.addTagValue("mapping", this.outputMapping[i], false) + "</connector>" + Const.CR;
        }
        retval = retval + "    </output>" + Const.CR;
        return retval;
    }

    @Override
    public void setDefault() {
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        if (this.mappingTransMeta != null) {
            StepMeta stepMeta = this.mappingTransMeta.getMappingOutputStep();
            stepMeta.getStepMetaInterface().getFields(r, name, info);
            for (int i = 0; i < this.outputMapping.length; ++i) {
                Value v = r.searchValue(this.outputMapping[i]);
                if (v == null) {
                    throw new ETLStepException("Mapping output field specified couldn't be found: " + this.outputMapping[i]);
                }
                v.setName(this.outputField[i]);
                v.setOrigin(name);
            }
            return r;
        }
        throw new ETLStepException("Unable to get fields from Mapping: no mapping is selected.");
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        int i;
        this.transName = rep.getStepAttributeString(id_step, "trans_name");
        this.fileName = rep.getStepAttributeString(id_step, "filename");
        this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
        int nrInput = rep.countNrStepAttributes(id_step, "input_field");
        int nrOutput = rep.countNrStepAttributes(id_step, "output_field");
        this.allocate(nrInput, nrOutput);
        for (i = 0; i < nrInput; ++i) {
            this.inputField[i] = rep.getStepAttributeString(id_step, i, "input_field");
            this.inputMapping[i] = rep.getStepAttributeString(id_step, i, "input_mapping");
        }
        for (i = 0; i < nrOutput; ++i) {
            this.outputField[i] = rep.getStepAttributeString(id_step, i, "output_field");
            this.outputMapping[i] = rep.getStepAttributeString(id_step, i, "output_mapping");
        }
        this.loadMappingMeta(rep);
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        int i;
        if (this.mappingTransMeta != null) {
            if (this.mappingTransMeta.getFilename() != null) {
                rep.saveStepAttribute(id_transformation, id_step, "filename", this.mappingTransMeta.getFilename());
            } else {
                rep.saveStepAttribute(id_transformation, id_step, "trans_name", this.mappingTransMeta.getName());
                if (this.mappingTransMeta.getDirectory() != null) {
                    rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.mappingTransMeta.getDirectory().getPath());
                }
            }
        }
        for (i = 0; i < this.inputField.length; ++i) {
            rep.saveStepAttribute(id_transformation, id_step, (long)i, "input_field", this.inputField[i]);
            rep.saveStepAttribute(id_transformation, id_step, (long)i, "input_mapping", this.inputMapping[i]);
        }
        for (i = 0; i < this.outputField.length; ++i) {
            rep.saveStepAttribute(id_transformation, id_step, (long)i, "output_field", this.outputField[i]);
            rep.saveStepAttribute(id_transformation, id_step, (long)i, "output_mapping", this.outputMapping[i]);
        }
    }

    private void loadMappingMeta(Repository rep) throws ETLException {
        if (this.fileName != null && this.fileName.length() > 0) {
            this.mappingTransMeta = new TransMeta(this.fileName, null);
        } else if (this.transName != null && this.directoryPath != null && rep != null) {
            RepositoryDirectory repdir = rep.getDirectoryTree().findDirectory(this.directoryPath);
            if (repdir != null) {
                this.mappingTransMeta = new TransMeta(rep, this.transName, repdir, null);
            } else {
                throw new ETLException("Unable to load transformation [" + this.transName + "] : can't find directory " + this.directoryPath);
            }
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
        }
        if (this.mappingTransMeta != null) {
            cr = new CheckResult(1, "A mapping (transformation) is specified.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No mapping is specified!", stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Mapping(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MappingData();
    }
}

