/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.mergerows;

import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mergerows.MergeRowsData;
import com.kingdee.bos.ctrl.etl.transformation.step.mergerows.MergeRowsMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class MergeRows
extends BaseStep
implements StepInterface {
    private static final Value VALUE_IDENTICAL = new Value("flag", "identical");
    private static final Value VALUE_CHANGED = new Value("flag", "changed");
    private static final Value VALUE_NEW = new Value("flag", "new");
    private static final Value VALUE_DELETED = new Value("flag", "deleted");
    private MergeRowsMeta meta;
    private MergeRowsData data;

    public MergeRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (MergeRowsMeta)smi;
        this.data = (MergeRowsData)sdi;
        if (this.first) {
            int i;
            this.first = false;
            this.data.one = this.getRowFrom(this.meta.getReferenceStepName());
            this.data.two = this.getRowFrom(this.meta.getCompareStepName());
            this.data.keyNrs = new int[this.meta.getKeyFields().length];
            this.data.keyAsc = new boolean[this.meta.getKeyFields().length];
            for (i = 0; i < this.data.keyNrs.length; ++i) {
                this.data.keyNrs[i] = this.data.one.searchValueIndex(this.meta.getKeyFields()[i]);
                if (this.data.keyNrs[i] < 0) {
                    String message = "Unable to find field [" + this.meta.getKeyFields()[i] + "] in reference stream.";
                    this.logError(message);
                    throw new ETLStepException(message);
                }
                this.data.keyAsc[i] = true;
            }
            this.data.valueNrs = new int[this.meta.getValueFields().length];
            this.data.valueAsc = new boolean[this.meta.getValueFields().length];
            for (i = 0; i < this.data.valueNrs.length; ++i) {
                this.data.valueNrs[i] = this.data.one.searchValueIndex(this.meta.getValueFields()[i]);
                if (this.data.valueNrs[i] < 0) {
                    String message = "Unable to find field [" + this.meta.getValueFields()[i] + "] in reference stream.";
                    this.logError(message);
                    throw new ETLStepException(message);
                }
                this.data.valueAsc[i] = true;
            }
        }
        this.logRowlevel("ONE: " + this.data.one + " / TWO: " + this.data.two);
        if (this.data.one == null && this.data.two == null) {
            this.setOutputDone();
            return false;
        }
        if (this.data.one == null && this.data.two != null) {
            this.data.two.addValue(VALUE_NEW);
            this.putRow(this.data.two);
            this.data.two = this.getRowFrom(this.meta.getCompareStepName());
        } else if (this.data.one != null && this.data.two == null) {
            this.data.one.addValue(VALUE_DELETED);
            this.putRow(this.data.one);
            this.data.one = this.getRowFrom(this.meta.getReferenceStepName());
        } else {
            int compare = this.data.one.compare(this.data.two, this.data.keyNrs, this.data.keyAsc);
            if (compare == 0) {
                int compareValues = this.data.one.compare(this.data.two, this.data.valueNrs, this.data.valueAsc);
                if (compareValues == 0) {
                    this.data.one.addValue(VALUE_IDENTICAL);
                    this.putRow(this.data.one);
                } else {
                    this.data.two.addValue(VALUE_CHANGED);
                    this.putRow(this.data.two);
                }
                this.data.one = this.getRowFrom(this.meta.getReferenceStepName());
                this.data.two = this.getRowFrom(this.meta.getCompareStepName());
            } else if (compare < 0) {
                this.data.one.addValue(VALUE_DELETED);
                this.putRow(this.data.one);
                this.data.one = this.getRowFrom(this.meta.getReferenceStepName());
            } else {
                this.data.two.addValue(VALUE_NEW);
                this.putRow(this.data.two);
                this.data.two = this.getRowFrom(this.meta.getReferenceStepName());
            }
        }
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MergeRowsMeta)smi;
        this.data = (MergeRowsData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getReferenceStepName() != null ^ this.meta.getCompareStepName() != null) {
                this.logError("Both the 'true' and the 'false' steps need to be supplied, or neither");
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

