/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.uniquerows;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.uniquerows.UniqueRows;
import com.kingdee.bos.ctrl.etl.transformation.step.uniquerows.UniqueRowsData;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class UniqueRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private boolean countRows;
    private String countField;
    private String[] compareFields;
    private boolean[] caseInsensitive;

    public boolean isCountRows() {
        return this.countRows;
    }

    public void setCountRows(boolean countRows) {
        this.countRows = countRows;
    }

    public String getCountField() {
        return this.countField;
    }

    public void setCountField(String countField) {
        this.countField = countField;
    }

    public void setCompareFields(String[] compareField) {
        this.compareFields = compareField;
    }

    public String[] getCompareFields() {
        return this.compareFields;
    }

    public void allocate(int nrfields) {
        this.compareFields = new String[nrfields];
        this.caseInsensitive = new boolean[nrfields];
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        UniqueRowsMeta retval = (UniqueRowsMeta)super.clone();
        int nrfields = this.compareFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.getCompareFields()[i] = this.compareFields[i];
            retval.getCaseInsensitive()[i] = this.caseInsensitive[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.countRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "count_rows"));
            this.countField = XMLHandler.getTagValue(stepnode, "count_field");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.compareFields[i] = XMLHandler.getTagValue(fnode, "name");
                this.caseInsensitive[i] = !"N".equalsIgnoreCase(XMLHandler.getTagValue(fnode, "name"));
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.countRows = false;
        this.countField = "";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.compareFields[i] = "field" + i;
            this.caseInsensitive[i] = true;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        if (this.countRows) {
            Value v = new Value(this.countField, 5);
            v.setLength(9, 0);
            v.setOrigin(name);
            r.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("count_rows", this.countRows);
        retval = retval + "      " + XMLHandler.addTagValue("count_field", this.countField);
        retval = retval + "    <fields>";
        for (int i = 0; i < this.compareFields.length; ++i) {
            retval = retval + "      <field>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.compareFields[i]);
            retval = retval + "        " + XMLHandler.addTagValue("case_insensitive", this.caseInsensitive[i]);
            retval = retval + "        </field>";
        }
        retval = retval + "      </fields>";
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.countRows = rep.getStepAttributeBoolean(id_step, "count_rows");
            this.countField = rep.getStepAttributeString(id_step, "count_fields");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.compareFields[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.caseInsensitive[i] = rep.getStepAttributeBoolean(id_step, i, "case_insensitive", true);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository ", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "count_rows", this.countRows);
            rep.saveStepAttribute(id_transformation, id_step, "count_fields", this.countField);
            for (int i = 0; i < this.compareFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.compareFields[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "case_insensitive", this.caseInsensitive[i]);
            }
        }
        catch (ETLException e) {
            throw new ETLException("Unable to save step information to the repository", e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            CheckResult cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new UniqueRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UniqueRowsData();
    }

    public boolean[] getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean[] caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }
}

