/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.util;

import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLHandler {
    public static final String getXMLHeader() {
        return XMLHandler.getXMLHeader("UTF-8");
    }

    public static final String getXMLHeader(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + Const.CR;
    }

    public static final String getTagValue(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static final String getTagValue(Node n, String tag, String subtag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            NodeList tags = childnode.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node tagnode = tags.item(j);
                if (!tagnode.getNodeName().equalsIgnoreCase(subtag) || tagnode.getFirstChild() == null) continue;
                return tagnode.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    public static final int countNodes(Node n, String tag) {
        int count = 0;
        if (n == null) {
            return 0;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            ++count;
        }
        return count;
    }

    public static final int countNodesWithTagValue(Node n, String tag, String subtag, String subtagvalue) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String value;
            Node tagnode;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (tagnode = XMLHandler.getSubNode(childnode, subtag)) == null || (value = XMLHandler.getNodeValue(tagnode)) == null || !value.equalsIgnoreCase(subtagvalue)) continue;
            ++count;
        }
        return count;
    }

    public static final int countNodesWithTagValueAndAnother(Node n, String tag, String subtag, String subtagvalue, String valtag, String valcont) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String value;
            Node tagnode;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (tagnode = XMLHandler.getSubNode(childnode, subtag)) == null || (value = XMLHandler.getNodeValue(tagnode)) == null || !value.equalsIgnoreCase(subtagvalue) || (tagnode = XMLHandler.getSubNode(childnode, valtag)) == null || (value = XMLHandler.getNodeValue(tagnode)) == null || !value.equalsIgnoreCase(valcont)) continue;
            ++count;
        }
        return count;
    }

    public static final Node getNodeWithTagValue(Node n, String tag, String subtag, String subtagvalue, int nr) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node tagnode;
            String value;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || !(value = XMLHandler.getNodeValue(tagnode = XMLHandler.getSubNode(childnode, subtag))).equalsIgnoreCase(subtagvalue)) continue;
            if (count == nr) {
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static final Node getNodeWithTagValueAndAnother(Node n, String tag, String subtag, String subtagvalue, int nr, String valtag, String valcont) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node tagnode;
            String value;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (value = XMLHandler.getNodeValue(tagnode = XMLHandler.getSubNode(childnode, subtag))) == null || !value.equalsIgnoreCase(subtagvalue) || (tagnode = XMLHandler.getSubNode(childnode, valtag)) == null || (value = XMLHandler.getNodeValue(tagnode)) == null || !value.equalsIgnoreCase(valcont)) continue;
            if (count == nr) {
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static final Node getSubNode(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            return childnode;
        }
        return null;
    }

    public static final Node getSubNode(Node n, String tag, String subtag) {
        Node t = XMLHandler.getSubNode(n, tag);
        if (t != null) {
            return XMLHandler.getSubNode(t, subtag);
        }
        return null;
    }

    public static final Node getSubNodeByNr(Node n, String tag, int nr) {
        if (n == null) {
            return null;
        }
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            if (count == nr) {
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static final Node getSubNodeByValue(Node n, String tag, String tagvalue) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String retval;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || !(retval = childnode.getNodeValue()).equalsIgnoreCase(tagvalue)) continue;
            return childnode;
        }
        return null;
    }

    public static final String getNodeValue(Node n) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            String retval = childnode.getNodeValue();
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public static final String getTagAttribute(Node node, String attribute) {
        Node attr;
        String retval = null;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (attr = nnm.getNamedItem(attribute)) != null) {
            retval = attr.getNodeValue();
        }
        return retval;
    }

    public static final Document loadXMLFile(String filename) throws ETLXMLException {
        LogWriter log = LogWriter.getInstance();
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(new File(FilenameUtils.normalize((String)filename)));
            }
            catch (FileNotFoundException ef) {
                log.logError(XMLHandler.getString(), "Error opening file: " + filename + " : " + ef.toString());
                return null;
            }
            return doc;
        }
        catch (Exception e) {
            throw new ETLXMLException("Error reading information from file", e);
        }
    }

    public static final Document loadXMLFile(InputStream is) throws ETLXMLException {
        LogWriter log = LogWriter.getInstance();
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(is);
            }
            catch (FileNotFoundException ef) {
                log.logError(XMLHandler.getString(), "Error opening InputStream: " + ef.toString());
                return null;
            }
            return doc;
        }
        catch (Exception e) {
            throw new ETLXMLException("Error reading information from file", e);
        }
    }

    public static final Document loadXMLString(String string) throws ETLXMLException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(new InputSource(new StringReader(string)));
            }
            catch (FileNotFoundException ef) {
                throw new ETLXMLException("Error parsing XML", ef);
            }
            return doc;
        }
        catch (Exception e) {
            throw new ETLXMLException("Error reading information from XML string : ", e);
        }
    }

    public static final String getString() {
        return XMLHandler.class.getName();
    }

    public static final String addTagValue(String tag, String val, boolean cr) {
        StringBuffer value;
        if (val != null) {
            value = new StringBuffer(val);
            Const.repl(value, "&", "&amp;");
            Const.repl(value, "'", "&apos;");
            Const.repl(value, "<", "&lt;");
            Const.repl(value, ">", "&gt;");
            Const.repl(value, "\"", "&quot;");
        } else {
            value = new StringBuffer();
        }
        return "<" + tag + ">" + value + "</" + tag + ">" + (cr ? Const.CR : "");
    }

    public static final String addTagValue(String tag, String val) {
        return XMLHandler.addTagValue(tag, val, true);
    }

    public static final String addTagValue(String tag, boolean bool) {
        return XMLHandler.addTagValue(tag, bool, true);
    }

    public static final String addTagValue(String tag, boolean bool, boolean cr) {
        return XMLHandler.addTagValue(tag, bool ? "Y" : "N", cr);
    }

    public static final String addTagValue(String tag, long l) {
        return XMLHandler.addTagValue(tag, l, true);
    }

    public static final String addTagValue(String tag, long l, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + l, cr);
    }

    public static final String addTagValue(String tag, int i) {
        return XMLHandler.addTagValue(tag, i, true);
    }

    public static final String addTagValue(String tag, int i, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + i, cr);
    }

    public static final String addTagValue(String tag, double d) {
        return XMLHandler.addTagValue(tag, d, true);
    }

    public static final String addTagValue(String tag, double d, boolean cr) {
        return XMLHandler.addTagValue(tag, "" + d, cr);
    }

    public static final String addTagValue(String tag, Date date) {
        return XMLHandler.addTagValue(tag, date, true);
    }

    public static final String addTagValue(String tag, Date date, boolean cr) {
        if (date == null) {
            XMLHandler.addTagValue(tag, (String)null, cr);
        }
        Value v = new Value("date", date);
        return XMLHandler.addTagValue(tag, v.getString(), cr);
    }

    public static String[] getNodeAttributes(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            String[] attributes = new String[nnm.getLength()];
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                attributes[i] = attr.getNodeName();
            }
            return attributes;
        }
        return null;
    }

    public static String[] getNodeElements(Node node) {
        ArrayList<String> elements = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName = nodeList.item(i).getNodeName();
            if (elements.indexOf(nodeName) >= 0) continue;
            elements.add(nodeName);
        }
        if (elements.size() == 0) {
            return null;
        }
        return elements.toArray(new String[elements.size()]);
    }
}

