/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.value;

import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.ValueInterface;
import java.math.BigDecimal;
import java.util.Date;

public class ValueBigNumber
implements ValueInterface,
Cloneable {
    private BigDecimal number;
    private int length;
    private int precision;

    public ValueBigNumber() {
        this.number = null;
        this.length = -1;
        this.precision = -1;
    }

    public ValueBigNumber(BigDecimal number) {
        this.number = number;
        this.length = -1;
        this.precision = -1;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String getTypeDesc() {
        return "BigNumber";
    }

    @Override
    public String getString() {
        if (this.number == null) {
            return null;
        }
        return this.number.toString();
    }

    @Override
    public double getNumber() {
        if (this.number == null) {
            return 0.0;
        }
        return this.number.doubleValue();
    }

    @Override
    public Date getDate() {
        if (this.number == null) {
            return null;
        }
        return new Date(this.number.longValue());
    }

    @Override
    public boolean getBoolean() {
        if (this.number == null) {
            return false;
        }
        return this.number.longValue() != 0L;
    }

    @Override
    public long getInteger() {
        if (this.number == null) {
            return 0L;
        }
        return this.number.longValue();
    }

    @Override
    public void setString(String string) {
        this.number = new BigDecimal(Const.toDouble(string, 0.0));
    }

    @Override
    public void setNumber(double number) {
        this.number = new BigDecimal(number);
    }

    @Override
    public void setDate(Date date) {
        this.number = new BigDecimal((double)date.getTime());
    }

    @Override
    public void setBoolean(boolean bool) {
        this.number = new BigDecimal(bool ? 1.0 : 0.0);
    }

    @Override
    public void setInteger(long number) {
        this.number = new BigDecimal((double)number);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setLength(int length, int precision) {
        this.length = length;
        this.precision = precision;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public Object clone() {
        try {
            ValueBigNumber retval = (ValueBigNumber)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigNumber() {
        return this.number;
    }

    @Override
    public void setBigNumber(BigDecimal number) {
        this.number = number;
    }
}

