/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.value;

import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.ValueInterface;
import java.math.BigDecimal;
import java.util.Date;

public class ValueInteger
implements ValueInterface,
Cloneable {
    private long number;
    private int length;

    public ValueInteger() {
        this.number = 0L;
        this.length = -1;
    }

    public ValueInteger(long number) {
        this.number = number;
        this.length = -1;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public String getTypeDesc() {
        return "Integer";
    }

    @Override
    public String getString() {
        return "" + this.number;
    }

    @Override
    public double getNumber() {
        return this.number;
    }

    @Override
    public Date getDate() {
        return new Date(this.number);
    }

    @Override
    public boolean getBoolean() {
        return this.number != 0L;
    }

    @Override
    public long getInteger() {
        return this.number;
    }

    @Override
    public void setString(String string) {
        this.number = Const.toLong(string, 0L);
    }

    @Override
    public void setNumber(double number) {
        this.number = Math.round(number);
    }

    @Override
    public void setDate(Date date) {
        this.number = date.getTime();
    }

    @Override
    public void setBoolean(boolean bool) {
        this.number = bool ? 1L : 0L;
    }

    @Override
    public void setInteger(long number) {
        this.number = number;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public void setLength(int length, int precision) {
        this.length = length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setPrecision(int precision) {
    }

    @Override
    public Object clone() {
        try {
            ValueInteger retval = (ValueInteger)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigNumber() {
        return new BigDecimal(this.number);
    }

    @Override
    public void setBigNumber(BigDecimal number) {
        this.number = number.longValue();
    }
}

