/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.cmp;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1Encodable;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.cmp.PKIBody;
import com.kingdee.bos.ctrl.cipher.asn1.cmp.PKIHeader;

public class ProtectedPart
extends ASN1Encodable {
    private PKIHeader header;
    private PKIBody body;

    private ProtectedPart(ASN1Sequence seq) {
        this.header = PKIHeader.getInstance(seq.getObjectAt(0));
        this.body = PKIBody.getInstance(seq.getObjectAt(1));
    }

    public static ProtectedPart getInstance(Object o) {
        if (o instanceof ProtectedPart) {
            return (ProtectedPart)o;
        }
        if (o instanceof ASN1Sequence) {
            return new ProtectedPart((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.header);
        v.add(this.body);
        return new DERSequence(v);
    }
}

