/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetString;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OutputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DERNull;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.oiw.ElGamalParameter;
import com.kingdee.bos.ctrl.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AuthorityKeyIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralName;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralNames;
import com.kingdee.bos.ctrl.cipher.asn1.x509.IssuingDistributionPoint;
import com.kingdee.bos.ctrl.cipher.asn1.x509.KeyUsage;
import com.kingdee.bos.ctrl.cipher.asn1.x509.RSAPublicKeyStructure;
import com.kingdee.bos.ctrl.cipher.asn1.x509.SubjectKeyIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.kingdee.bos.ctrl.cipher.asn1.x509.TBSCertList;
import com.kingdee.bos.ctrl.cipher.asn1.x509.TBSCertificateStructure;
import com.kingdee.bos.ctrl.cipher.asn1.x509.Time;
import com.kingdee.bos.ctrl.cipher.asn1.x509.V1TBSCertificateGenerator;
import com.kingdee.bos.ctrl.cipher.asn1.x509.V2TBSCertListGenerator;
import com.kingdee.bos.ctrl.cipher.asn1.x509.V3TBSCertificateGenerator;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Extension;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Extensions;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Name;
import com.kingdee.bos.ctrl.cipher.util.Arrays;
import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class GenerationTest
extends SimpleTest {
    private byte[] v1Cert = Base64.decode("MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode("MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v3CertNullSubject = Base64.decode("MIHGoAMCAQICAQIwDQYJKoZIhvcNAQEEBQAwJTELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUwHhcNNzAwMTAxMDAwMDAxWhcNNzAwMTAxMDAwMDAyWjAAMBgwEAYGKw4HAgEBMAYCAQECAQIDBAACAQOjSjBIMEYGA1UdEQEB/wQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAy");
    private byte[] v2CertList = Base64.decode("MIIBRQIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAkMCICAQEXDTcwMDEwMTAwMDAwMVowDjAMBgNVHRUEBQoDAIAAoIHFMIHCMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMEMGA1UdEgQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAzMAoGA1UdFAQDAgEBMAwGA1UdHAEB/wQCMAA=");

    private void tbsV1CertGen() throws IOException {
        V1TBSCertificateGenerator gen = new V1TBSCertificateGenerator();
        Date startDate = new Date(1000L);
        Date endDate = new Date(12000L);
        gen.setSerialNumber(new DERInteger(1));
        gen.setStartDate(new Time(startDate));
        gen.setEndDate(new Time(endDate));
        gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
        gen.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPublicKeyStructure(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
        gen.setSubjectPublicKeyInfo(info);
        TBSCertificateStructure tbs = gen.generateTBSCertificate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v1Cert)) {
            this.fail("failed v1 cert generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v1Cert));
        DERObject o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v1Cert)) {
            this.fail("failed v1 cert read back test");
        }
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo info, X509Name name, int sNumber) {
        GeneralName genName = new GeneralName(name);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(genName);
        return new AuthorityKeyIdentifier(info, new GeneralNames(new DERSequence(v)), BigInteger.valueOf(sNumber));
    }

    private void tbsV3CertGen() throws IOException {
        V3TBSCertificateGenerator gen = new V3TBSCertificateGenerator();
        Date startDate = new Date(1000L);
        Date endDate = new Date(2000L);
        gen.setSerialNumber(new DERInteger(2));
        gen.setStartDate(new Time(startDate));
        gen.setEndDate(new Time(endDate));
        gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
        gen.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
        gen.setSubjectPublicKeyInfo(info);
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, X509Extension> extensions = new Hashtable<DERObjectIdentifier, X509Extension>();
        order.addElement(X509Extensions.AuthorityKeyIdentifier);
        order.addElement(X509Extensions.SubjectKeyIdentifier);
        order.addElement(X509Extensions.KeyUsage);
        extensions.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(info, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
        extensions.put(X509Extensions.SubjectKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(new SubjectKeyIdentifier(info))));
        extensions.put(X509Extensions.KeyUsage, new X509Extension(false, (ASN1OctetString)new DEROctetString(new KeyUsage(16))));
        X509Extensions ex = new X509Extensions(order, extensions);
        gen.setExtensions(ex);
        TBSCertificateStructure tbs = gen.generateTBSCertificate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3Cert)) {
            this.fail("failed v3 cert generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v3Cert));
        DERObject o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3Cert)) {
            this.fail("failed v3 cert read back test");
        }
    }

    private void tbsV3CertGenWithNullSubject() throws IOException {
        V3TBSCertificateGenerator gen;
        block4: {
            gen = new V3TBSCertificateGenerator();
            Date startDate = new Date(1000L);
            Date endDate = new Date(2000L);
            gen.setSerialNumber(new DERInteger(2));
            gen.setStartDate(new Time(startDate));
            gen.setEndDate(new Time(endDate));
            gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
            gen.setSubjectPublicKeyInfo(info);
            try {
                gen.generateTBSCertificate();
                this.fail("null subject not caught!");
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("not all mandatory fields set in V3 TBScertificate generator")) break block4;
                this.fail("unexpected exception", e);
            }
        }
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, X509Extension> extensions = new Hashtable<DERObjectIdentifier, X509Extension>();
        order.addElement(X509Extensions.SubjectAlternativeName);
        extensions.put(X509Extensions.SubjectAlternativeName, new X509Extension(true, (ASN1OctetString)new DEROctetString(new GeneralNames(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"))))));
        X509Extensions ex = new X509Extensions(order, extensions);
        gen.setExtensions(ex);
        TBSCertificateStructure tbs = gen.generateTBSCertificate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v3CertNullSubject));
        DERObject o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert read back test");
        }
    }

    private void tbsV2CertListGen() throws IOException {
        V2TBSCertListGenerator gen = new V2TBSCertListGenerator();
        gen.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
        gen.addCRLEntry(new DERInteger(1), new Time(new Date(1000L)), 32768);
        gen.setNextUpdate(new Time(new Date(2000L)));
        gen.setThisUpdate(new Time(new Date(500L)));
        gen.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, new DERNull()));
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, X509Extension> extensions = new Hashtable<DERObjectIdentifier, X509Extension>();
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
        order.addElement(X509Extensions.AuthorityKeyIdentifier);
        order.addElement(X509Extensions.IssuerAlternativeName);
        order.addElement(X509Extensions.CRLNumber);
        order.addElement(X509Extensions.IssuingDistributionPoint);
        extensions.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(info, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
        extensions.put(X509Extensions.IssuerAlternativeName, new X509Extension(false, (ASN1OctetString)new DEROctetString(new GeneralNames(new DERSequence(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 3")))))));
        extensions.put(X509Extensions.CRLNumber, new X509Extension(false, (ASN1OctetString)new DEROctetString(new DERInteger(1))));
        extensions.put(X509Extensions.IssuingDistributionPoint, new X509Extension(true, (ASN1OctetString)new DEROctetString(new IssuingDistributionPoint(new DERSequence()))));
        X509Extensions ex = new X509Extensions(order, extensions);
        gen.setExtensions(ex);
        TBSCertList tbs = gen.generateTBSCertList();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(tbs);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v2CertList)) {
            this.fail("failed v2 cert list generation");
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
        DERObject o = aIn.readObject();
        bOut = new ByteArrayOutputStream();
        aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(o);
        if (!Arrays.areEqual(bOut.toByteArray(), this.v2CertList)) {
            this.fail("failed v2 cert list read back test");
        }
    }

    @Override
    public void performTest() throws Exception {
        this.tbsV1CertGen();
        this.tbsV3CertGen();
        this.tbsV3CertGenWithNullSubject();
        this.tbsV2CertListGen();
    }

    @Override
    public String getName() {
        return "Generation";
    }

    public static void main(String[] args) {
        GenerationTest.runTest(new GenerationTest());
    }
}

