/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetStringParser;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1SequenceParser;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1StreamParser;
import com.kingdee.bos.ctrl.cipher.asn1.BEROctetStringGenerator;
import com.kingdee.bos.ctrl.cipher.asn1.BERSequenceGenerator;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequenceGenerator;
import com.kingdee.bos.ctrl.cipher.asn1.cms.CMSObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.asn1.cms.CompressedDataParser;
import com.kingdee.bos.ctrl.cipher.asn1.cms.ContentInfoParser;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class OctetStringTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingWriting() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(bOut);
        OutputStream out = null;
        try {
            out = octGen.getOctetOutputStream();
            out.write(new byte[]{1, 2, 3, 4});
            out.write(new byte[4]);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
        ASN1StreamParser aIn = new ASN1StreamParser(bOut.toByteArray());
        ASN1OctetStringParser s = (ASN1OctetStringParser)aIn.readObject();
        InputStream in = null;
        try {
            in = s.getOctetStream();
            int count = 0;
            while (in.read() >= 0) {
                ++count;
            }
            OctetStringTest.assertEquals((int)8, (int)count);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingWritingZeroInLength() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(bOut);
        OutputStream out = octGen.getOctetOutputStream();
        out.write(new byte[]{1, 2, 3, 4});
        out.write(new byte[512]);
        out.close();
        ASN1StreamParser aIn = new ASN1StreamParser(bOut.toByteArray());
        ASN1OctetStringParser s = (ASN1OctetStringParser)aIn.readObject();
        InputStream in = null;
        try {
            in = s.getOctetStream();
            int count = 0;
            while (in.read() >= 0) {
                ++count;
            }
            OctetStringTest.assertEquals((int)516, (int)count);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingWritingNested() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BERSequenceGenerator sGen = new BERSequenceGenerator(bOut);
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(sGen.getRawOutputStream());
        OutputStream out = null;
        BERSequenceGenerator inSGen = null;
        OutputStream inOut = null;
        try {
            out = octGen.getOctetOutputStream();
            inSGen = new BERSequenceGenerator(out);
            BEROctetStringGenerator inOctGen = new BEROctetStringGenerator(inSGen.getRawOutputStream());
            inOut = inOctGen.getOctetOutputStream();
            inOut.write(new byte[]{1, 2, 3, 4});
            inOut.write(new byte[10]);
            inSGen.close();
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inOut, out});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inOut, out});
        sGen.close();
        ASN1StreamParser aIn = new ASN1StreamParser(bOut.toByteArray());
        ASN1SequenceParser sq = (ASN1SequenceParser)aIn.readObject();
        ASN1OctetStringParser s = (ASN1OctetStringParser)sq.readObject();
        ASN1StreamParser aIn2 = new ASN1StreamParser(s.getOctetStream());
        ASN1SequenceParser sq2 = (ASN1SequenceParser)aIn2.readObject();
        ASN1OctetStringParser inS = (ASN1OctetStringParser)sq2.readObject();
        InputStream in = null;
        try {
            int count = 0;
            in = inS.getOctetStream();
            while (in.read() >= 0) {
                ++count;
            }
            OctetStringTest.assertEquals((int)14, (int)count);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedStructure() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BERSequenceGenerator sGen = new BERSequenceGenerator(bOut);
        sGen.addObject(new DERObjectIdentifier(CMSObjectIdentifiers.compressedData.getId()));
        BERSequenceGenerator cGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        cGen.addObject(new DERInteger(0));
        DERSequenceGenerator algGen = new DERSequenceGenerator(cGen.getRawOutputStream());
        algGen.addObject(new DERObjectIdentifier("1.2"));
        algGen.close();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(cGen.getRawOutputStream());
        eiGen.addObject(new DERObjectIdentifier("1.1"));
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, true);
        OutputStream out = null;
        try {
            out = octGen.getOctetOutputStream();
            out.write(new byte[]{1, 2, 3, 4});
            out.write(new byte[4]);
            out.write(new byte[20]);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out});
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
        eiGen.close();
        cGen.close();
        sGen.close();
        ASN1StreamParser aIn = new ASN1StreamParser(bOut.toByteArray());
        ContentInfoParser cp = new ContentInfoParser((ASN1SequenceParser)aIn.readObject());
        CompressedDataParser comData = new CompressedDataParser((ASN1SequenceParser)cp.getContent(16));
        ContentInfoParser content = comData.getEncapContentInfo();
        ASN1OctetStringParser bytes = (ASN1OctetStringParser)content.getContent(4);
        InputStream in = bytes.getOctetStream();
        int count = 0;
        while (in.read() >= 0) {
            ++count;
        }
        OctetStringTest.assertEquals((int)28, (int)count);
    }

    public static Test suite() {
        return new TestSuite(OctetStringTest.class);
    }
}

