/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.bcpg;

import com.kingdee.bos.ctrl.cipher.bcpg.BCPGInputStream;
import com.kingdee.bos.ctrl.cipher.bcpg.BCPGOutputStream;
import com.kingdee.bos.ctrl.cipher.bcpg.ContainedPacket;
import com.kingdee.bos.ctrl.cipher.util.Strings;
import java.io.IOException;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream in) throws IOException {
        this.idData = new byte[in.available()];
        in.readFully(this.idData);
    }

    public UserIDPacket(String id) {
        this.idData = Strings.toUTF8ByteArray(id);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(13, this.idData, true);
    }
}

