/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.agreement.kdf;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.DERNull;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERTaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.crypto.DataLengthException;
import com.kingdee.bos.ctrl.cipher.crypto.DerivationFunction;
import com.kingdee.bos.ctrl.cipher.crypto.DerivationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.Digest;
import com.kingdee.bos.ctrl.cipher.crypto.agreement.kdf.DHKDFParameters;
import com.kingdee.bos.ctrl.cipher.crypto.generators.KDF2BytesGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.params.KDFParameters;

public class ECDHKEKGenerator
implements DerivationFunction {
    private DerivationFunction kdf;
    private DERObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    @Override
    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new AlgorithmIdentifier(this.algorithm, new DERNull()));
        v.add(new DERTaggedObject(true, 2, new DEROctetString(this.integerToBytes(this.keySize))));
        this.kdf.init(new KDFParameters(this.z, new DERSequence(v).getDEREncoded()));
        return this.kdf.generateBytes(out, outOff, len);
    }

    private byte[] integerToBytes(int keySize) {
        byte[] val = new byte[]{(byte)(keySize >> 24), (byte)(keySize >> 16), (byte)(keySize >> 8), (byte)keySize};
        return val;
    }
}

