/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.engines;

import com.kingdee.bos.ctrl.cipher.crypto.BlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.CipherParameters;
import com.kingdee.bos.ctrl.cipher.crypto.DataLengthException;
import com.kingdee.bos.ctrl.cipher.crypto.InvalidCipherTextException;
import com.kingdee.bos.ctrl.cipher.crypto.Wrapper;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithRandom;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher engine) {
        this.engine = engine;
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.param = (KeyParameter)param;
        } else if (param instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)param).getIV();
            this.param = (KeyParameter)((ParametersWithIV)param).getParameters();
            if (this.iv.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n = inLen / 8;
        if (n * 8 != inLen) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] block = new byte[inLen + this.iv.length];
        byte[] buf = new byte[8 + this.iv.length];
        System.arraycopy(this.iv, 0, block, 0, this.iv.length);
        System.arraycopy(in, 0, block, this.iv.length, inLen);
        this.engine.init(true, this.param);
        for (int j = 0; j != 6; ++j) {
            for (int i = 1; i <= n; ++i) {
                System.arraycopy(block, 0, buf, 0, this.iv.length);
                System.arraycopy(block, 8 * i, buf, this.iv.length, 8);
                this.engine.processBlock(buf, 0, buf, 0);
                int t = n * j + i;
                int k = 1;
                while (t != 0) {
                    byte v = (byte)t;
                    int n2 = this.iv.length - k;
                    buf[n2] = (byte)(buf[n2] ^ v);
                    t >>>= 8;
                    ++k;
                }
                System.arraycopy(buf, 0, block, 0, 8);
                System.arraycopy(buf, 8, block, 8 * i, 8);
            }
        }
        return block;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n = inLen / 8;
        if (n * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] block = new byte[inLen - this.iv.length];
        byte[] a = new byte[this.iv.length];
        byte[] buf = new byte[8 + this.iv.length];
        System.arraycopy(in, 0, a, 0, this.iv.length);
        System.arraycopy(in, this.iv.length, block, 0, inLen - this.iv.length);
        this.engine.init(false, this.param);
        --n;
        for (int j = 5; j >= 0; --j) {
            for (int i = n; i >= 1; --i) {
                System.arraycopy(a, 0, buf, 0, this.iv.length);
                System.arraycopy(block, 8 * (i - 1), buf, this.iv.length, 8);
                int t = n * j + i;
                int k = 1;
                while (t != 0) {
                    byte v = (byte)t;
                    int n2 = this.iv.length - k;
                    buf[n2] = (byte)(buf[n2] ^ v);
                    t >>>= 8;
                    ++k;
                }
                this.engine.processBlock(buf, 0, buf, 0);
                System.arraycopy(buf, 0, a, 0, 8);
                System.arraycopy(buf, 8, block, 8 * (i - 1), 8);
            }
        }
        for (int i = 0; i != this.iv.length; ++i) {
            if (a[i] == this.iv[i]) continue;
            throw new InvalidCipherTextException("checksum failed");
        }
        return block;
    }
}

