/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.generators;

import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPair;
import com.kingdee.bos.ctrl.cipher.crypto.AsymmetricCipherKeyPairGenerator;
import com.kingdee.bos.ctrl.cipher.crypto.KeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.GOST3410KeyGenerationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.GOST3410Parameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.GOST3410PrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.GOST3410PublicKeyParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private GOST3410KeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (GOST3410KeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        GOST3410Parameters GOST3410Params = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = GOST3410Params.getQ();
        BigInteger p = GOST3410Params.getP();
        BigInteger a = GOST3410Params.getA();
        while ((x = new BigInteger(256, random)).equals(ZERO) || x.compareTo(q) >= 0) {
        }
        BigInteger y = a.modPow(x, p);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(y, GOST3410Params), new GOST3410PrivateKeyParameters(x, GOST3410Params));
    }
}

