/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.math.ec.test;

import com.kingdee.bos.ctrl.cipher.asn1.sec.SECNamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ECParameters;
import com.kingdee.bos.ctrl.cipher.math.ec.ECCurve;
import com.kingdee.bos.ctrl.cipher.math.ec.ECFieldElement;
import com.kingdee.bos.ctrl.cipher.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ECPointTest
extends TestCase {
    private SecureRandom secRand = new SecureRandom();
    private Fp fp = null;
    private F2m f2m = null;

    public void setUp() {
        this.fp = new Fp();
        this.fp.createPoints();
        this.f2m = new F2m();
        this.f2m.createPoints();
    }

    public void testPointCreationConsistency() {
        ECPoint bad2;
        try {
            bad2 = new ECPoint.Fp(this.fp.curve, new ECFieldElement.Fp(this.fp.q, new BigInteger("12")), null);
            ECPointTest.fail();
        }
        catch (IllegalArgumentException bad2) {
            // empty catch block
        }
        try {
            bad2 = new ECPoint.Fp(this.fp.curve, null, new ECFieldElement.Fp(this.fp.q, new BigInteger("12")));
            ECPointTest.fail();
        }
        catch (IllegalArgumentException bad3) {
            // empty catch block
        }
        try {
            bad2 = new ECPoint.F2m(this.f2m.curve, new ECFieldElement.F2m(4, 1, new BigInteger("1011")), null);
            ECPointTest.fail();
        }
        catch (IllegalArgumentException bad4) {
            // empty catch block
        }
        try {
            bad2 = new ECPoint.F2m(this.f2m.curve, null, new ECFieldElement.F2m(4, 1, new BigInteger("1011")));
            ECPointTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void implTestAdd(ECPoint[] p, ECPoint infinity) {
        ECPointTest.assertEquals((String)"p0 plus p1 does not equal p2", (Object)p[2], (Object)p[0].add(p[1]));
        ECPointTest.assertEquals((String)"p1 plus p0 does not equal p2", (Object)p[2], (Object)p[1].add(p[0]));
        for (int i = 0; i < p.length; ++i) {
            ECPointTest.assertEquals((String)"Adding infinity failed", (Object)p[i], (Object)p[i].add(infinity));
            ECPointTest.assertEquals((String)"Adding to infinity failed", (Object)p[i], (Object)infinity.add(p[i]));
        }
    }

    public void testAdd() {
        this.implTestAdd(this.fp.p, this.fp.infinity);
        this.implTestAdd(this.f2m.p, this.f2m.infinity);
    }

    private void implTestTwice(ECPoint[] p) {
        ECPointTest.assertEquals((String)"Twice incorrect", (Object)p[3], (Object)p[0].twice());
        ECPointTest.assertEquals((String)"Add same point incorrect", (Object)p[3], (Object)p[0].add(p[0]));
    }

    public void testTwice() {
        this.implTestTwice(this.fp.p);
        this.implTestTwice(this.f2m.p);
    }

    private void implTestAllPoints(ECPoint p, ECPoint infinity) {
        ECPoint adder = infinity;
        ECPoint multiplier = infinity;
        int i = 1;
        do {
            adder = adder.add(p);
            multiplier = p.multiply(new BigInteger(Integer.toString(i)));
            ECPointTest.assertEquals((String)("Results of add() and multiply() are inconsistent " + i), (Object)adder, (Object)multiplier);
            ++i;
        } while (!adder.equals(infinity));
    }

    public void testAllPoints() {
        int i;
        for (i = 0; i < this.fp.p.length; ++i) {
            this.implTestAllPoints(this.fp.p[0], this.fp.infinity);
        }
        for (i = 0; i < this.f2m.p.length; ++i) {
            this.implTestAllPoints(this.f2m.p[0], this.f2m.infinity);
        }
    }

    private ECPoint multiply(ECPoint p, BigInteger k) {
        ECPoint q = p.getCurve().getInfinity();
        int t = k.bitLength();
        for (int i = 0; i < t; ++i) {
            if (k.testBit(i)) {
                q = q.add(p);
            }
            p = p.twice();
        }
        return q;
    }

    private void implTestMultiply(ECPoint p, int numBits) {
        BigInteger k = new BigInteger(numBits, this.secRand);
        ECPoint ref = this.multiply(p, k);
        ECPoint q = p.multiply(k);
        ECPointTest.assertEquals((String)"ECPoint.multiply is incorrect", (Object)ref, (Object)q);
    }

    private void implTestMultiplyAll(ECPoint p, int numBits) {
        BigInteger bound = BigInteger.valueOf(2L).pow(numBits);
        BigInteger k = BigInteger.ZERO;
        do {
            ECPoint ref = this.multiply(p, k);
            ECPoint q = p.multiply(k);
            ECPointTest.assertEquals((String)"ECPoint.multiply is incorrect", (Object)ref, (Object)q);
        } while ((k = k.add(BigInteger.ONE)).compareTo(bound) < 0);
    }

    private void implTestAddSubtract(ECPoint p, ECPoint infinity) {
        ECPointTest.assertEquals((String)"Twice and Add inconsistent", (Object)p.twice(), (Object)p.add(p));
        ECPointTest.assertEquals((String)"Twice p - p is not p", (Object)p, (Object)p.twice().subtract(p));
        ECPointTest.assertEquals((String)"p - p is not infinity", (Object)infinity, (Object)p.subtract(p));
        ECPointTest.assertEquals((String)"p plus infinity is not p", (Object)p, (Object)p.add(infinity));
        ECPointTest.assertEquals((String)"infinity plus p is not p", (Object)p, (Object)infinity.add(p));
        ECPointTest.assertEquals((String)"infinity plus infinity is not infinity ", (Object)infinity, (Object)infinity.add(infinity));
    }

    public void testAddSubtractMultiplySimple() {
        for (int iFp = 0; iFp < this.fp.pointSource.length / 2; ++iFp) {
            this.implTestAddSubtract(this.fp.p[iFp], this.fp.infinity);
            this.implTestMultiplyAll(this.fp.p[iFp], 6);
            this.implTestMultiplyAll(this.fp.infinity, 6);
        }
        for (int iF2m = 0; iF2m < this.f2m.pointSource.length / 2; ++iF2m) {
            this.implTestAddSubtract(this.f2m.p[iF2m], this.f2m.infinity);
            this.implTestMultiplyAll(this.f2m.p[iF2m], 6);
            this.implTestMultiplyAll(this.f2m.infinity, 6);
        }
    }

    private void implTestEncoding(ECPoint p) {
        ECPoint compP;
        ECPoint unCompP;
        if (p instanceof ECPoint.Fp) {
            unCompP = new ECPoint.Fp(p.getCurve(), p.getX(), p.getY(), false);
            compP = new ECPoint.Fp(p.getCurve(), p.getX(), p.getY(), true);
        } else {
            unCompP = new ECPoint.F2m(p.getCurve(), p.getX(), p.getY(), false);
            compP = new ECPoint.F2m(p.getCurve(), p.getX(), p.getY(), true);
        }
        byte[] unCompBarr = unCompP.getEncoded();
        ECPoint decUnComp = p.getCurve().decodePoint(unCompBarr);
        ECPointTest.assertEquals((String)"Error decoding uncompressed point", (Object)p, (Object)decUnComp);
        byte[] compBarr = compP.getEncoded();
        ECPoint decComp = p.getCurve().decodePoint(compBarr);
        ECPointTest.assertEquals((String)"Error decoding compressed point", (Object)p, (Object)decComp);
    }

    public void testAddSubtractMultiplyTwiceEncoding() {
        Enumeration curveEnum = SECNamedCurves.getNames();
        while (curveEnum.hasMoreElements()) {
            String name = (String)curveEnum.nextElement();
            X9ECParameters x9ECParameters = SECNamedCurves.getByName(name);
            BigInteger n = x9ECParameters.getN();
            BigInteger b = new BigInteger(n.bitLength(), this.secRand);
            ECPoint g = x9ECParameters.getG();
            ECPoint q = g.multiply(b);
            ECPoint infinity = x9ECParameters.getCurve().getInfinity();
            this.implTestAddSubtract(q, infinity);
            this.implTestMultiply(q, n.bitLength());
            this.implTestMultiply(infinity, n.bitLength());
            this.implTestEncoding(q);
        }
    }

    public static Test suite() {
        return new TestSuite(ECPointTest.class);
    }

    public static class F2m {
        private final int m = 4;
        private final int k1 = 1;
        private final ECFieldElement.F2m aTpb = new ECFieldElement.F2m(4, 1, new BigInteger("1000", 2));
        private final ECFieldElement.F2m bTpb = new ECFieldElement.F2m(4, 1, new BigInteger("1001", 2));
        private final ECCurve.F2m curve = new ECCurve.F2m(4, 1, this.aTpb.toBigInteger(), this.bTpb.toBigInteger());
        private final ECPoint.F2m infinity = (ECPoint.F2m)this.curve.getInfinity();
        private final String[] pointSource = new String[]{"0010", "1111", "1100", "1100", "0001", "0001", "1011", "0010"};
        private ECPoint.F2m[] p = new ECPoint.F2m[this.pointSource.length / 2];

        private void createPoints() {
            for (int i = 0; i < this.pointSource.length / 2; ++i) {
                ECFieldElement.F2m x = new ECFieldElement.F2m(4, 1, new BigInteger(this.pointSource[2 * i], 2));
                ECFieldElement.F2m y = new ECFieldElement.F2m(4, 1, new BigInteger(this.pointSource[2 * i + 1], 2));
                this.p[i] = new ECPoint.F2m(this.curve, x, y);
            }
        }
    }

    public static class Fp {
        private final BigInteger q = new BigInteger("29");
        private final BigInteger a = new BigInteger("4");
        private final BigInteger b = new BigInteger("20");
        private final ECCurve.Fp curve = new ECCurve.Fp(this.q, this.a, this.b);
        private final ECPoint.Fp infinity = (ECPoint.Fp)this.curve.getInfinity();
        private final int[] pointSource = new int[]{5, 22, 16, 27, 13, 6, 14, 6};
        private ECPoint.Fp[] p = new ECPoint.Fp[this.pointSource.length / 2];

        private void createPoints() {
            for (int i = 0; i < this.pointSource.length / 2; ++i) {
                ECFieldElement.Fp x = new ECFieldElement.Fp(this.q, new BigInteger(Integer.toString(this.pointSource[2 * i])));
                ECFieldElement.Fp y = new ECFieldElement.Fp(this.q, new BigInteger(Integer.toString(this.pointSource[2 * i + 1])));
                this.p[i] = new ECPoint.Fp(this.curve, x, y);
            }
        }
    }
}

