/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.ext.BasicExtCallback;
import com.kingdee.bos.ctrl.ext.CardLayoutAction;
import com.kingdee.bos.ctrl.ext.ClearExtMacrosUserObjectAction;
import com.kingdee.bos.ctrl.ext.ConsolePopAction;
import com.kingdee.bos.ctrl.ext.ConvenientKeyWizzardAction;
import com.kingdee.bos.ctrl.ext.DatasetManageAction;
import com.kingdee.bos.ctrl.ext.ExportAction;
import com.kingdee.bos.ctrl.ext.FIParamEditAction;
import com.kingdee.bos.ctrl.ext.FieldPermissionAction;
import com.kingdee.bos.ctrl.ext.FilterUILayoutAction;
import com.kingdee.bos.ctrl.ext.IExtActionManager;
import com.kingdee.bos.ctrl.ext.ImportAction;
import com.kingdee.bos.ctrl.ext.ImportHistory;
import com.kingdee.bos.ctrl.ext.InsertComboBoxAction;
import com.kingdee.bos.ctrl.ext.InsertDatePickerAction;
import com.kingdee.bos.ctrl.ext.InsertEllipseAction;
import com.kingdee.bos.ctrl.ext.InsertFlashChartAction;
import com.kingdee.bos.ctrl.ext.InsertLabelAction;
import com.kingdee.bos.ctrl.ext.InsertPicAction;
import com.kingdee.bos.ctrl.ext.InsertRectangleAction;
import com.kingdee.bos.ctrl.ext.InsertResourceAction;
import com.kingdee.bos.ctrl.ext.InsertTextFieldAction;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.NewAction;
import com.kingdee.bos.ctrl.ext.ParameterDesignAction;
import com.kingdee.bos.ctrl.ext.PreviewAction;
import com.kingdee.bos.ctrl.ext.PushAndWarningAction;
import com.kingdee.bos.ctrl.ext.QuitAction;
import com.kingdee.bos.ctrl.ext.ReportCalcConstraintsAction;
import com.kingdee.bos.ctrl.ext.ReportViewConstraintsAction;
import com.kingdee.bos.ctrl.ext.ReportWizardAction;
import com.kingdee.bos.ctrl.ext.ReportingConstraintsSettingAction;
import com.kingdee.bos.ctrl.ext.SaveAction;
import com.kingdee.bos.ctrl.ext.SaveAsAction;
import com.kingdee.bos.ctrl.ext.SaveAsExtenalMacrosAction;
import com.kingdee.bos.ctrl.ext.TrimManageAction;
import java.util.HashMap;
import javax.swing.Action;

public final class ExtActionManager
implements IExtActionManager {
    private HashMap _actionMap;
    private KDExt _ext;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, ExtActionManager.class, (String)defaultStr);
    }

    ExtActionManager(KDExt ext) {
        this._ext = ext;
    }

    @Override
    public Action getAction(String name, boolean create) {
        Action action = null;
        if (this._actionMap != null) {
            action = (Action)this._actionMap.get(name);
        }
        if (action == null && create && (action = this.createAction(name)) != null) {
            this.putAction(name, action);
        }
        return action;
    }

    @Override
    public Action getAction(String name) {
        return this.getAction(name, true);
    }

    private void putAction(String name, Action action) {
        if (this._actionMap == null) {
            this._actionMap = new HashMap();
        }
        this._actionMap.put(name, action);
    }

    private Action createAction(String name) {
        if ("SHOW_EXPORT_WIZARD".equals(name)) {
            return new ExportAction(this._ext);
        }
        if ("SHOW_IMPORT_WIZARD".equals(name)) {
            return new ImportAction(this._ext);
        }
        if ("EXT_SAVE".equals(name)) {
            return new SaveAction(this._ext);
        }
        if ("EXT_PREVIEW".equals(name)) {
            return new PreviewAction(this._ext);
        }
        if ("EXT_DATA_MANAGE".equals(name)) {
            return new DatasetManageAction(this._ext);
        }
        if ("EXT_FIELD_PERMISSION".equals(name)) {
            return new FieldPermissionAction(this._ext);
        }
        if ("EXT_QUIT".equals(name)) {
            return new QuitAction(this._ext);
        }
        if ("EXT_NEW".equals(name)) {
            return new NewAction(this._ext);
        }
        if ("EXT_REPORT_WIZARD".equals(name)) {
            return new ReportWizardAction(this._ext);
        }
        if ("EXT_TRIM_MANAGE".equals(name)) {
            return new TrimManageAction(this._ext);
        }
        if ("EXT_SAVE_AS".equals(name)) {
            return new SaveAsAction(this._ext);
        }
        if ("EXT_PARAMS_DESIGN".equals(name)) {
            return new ParameterDesignAction(this._ext);
        }
        if ("EXT_INSERT_ELLIPSE".equals(name)) {
            return new InsertEllipseAction(this._ext);
        }
        if ("EXT_INSERT_RECTANGLE".equals(name)) {
            return new InsertRectangleAction(this._ext);
        }
        if ("EXT_INSERT_DATEPICKER".equals(name)) {
            return new InsertDatePickerAction(this._ext);
        }
        if ("EXT_INSERT_LABEL".equals(name)) {
            return new InsertLabelAction(this._ext);
        }
        if ("EXT_INSERT_TEXTFIELD".equals(name)) {
            return new InsertTextFieldAction(this._ext);
        }
        if ("EXT_INSERT_COMBOBOX".equals(name)) {
            return new InsertComboBoxAction(this._ext);
        }
        if ("EXT_CONSOLE".equals(name)) {
            return new ConsolePopAction(this._ext);
        }
        if ("EXT_VIEWCONSTRAINTS".equals(name)) {
            return new ReportViewConstraintsAction(this._ext);
        }
        if ("User_Defined_ConvenientKey".equals(name)) {
            return new ConvenientKeyWizzardAction(this._ext);
        }
        if ("EXT_INSERTPIC".equals(name)) {
            return new InsertPicAction(this._ext);
        }
        if ("EXT_INSERTRES".equals(name)) {
            return new InsertResourceAction(this._ext);
        }
        if ("EXT_INSERT_FLASHCHART".equals(name)) {
            return new InsertFlashChartAction(this._ext);
        }
        if ("User_Open_History" == name && this._ext.getExtCallback() instanceof BasicExtCallback) {
            return new ImportHistory(this._ext);
        }
        if ("EXT_CALCCONSTRAINTS".equals(name)) {
            return new ReportCalcConstraintsAction(this._ext);
        }
        if ("EXT_FILTERUI_LAYOUT".equals(name)) {
            return new FilterUILayoutAction(this._ext);
        }
        if ("EXT_REPORTINGCONSTRAINTS".equals(name)) {
            return new ReportingConstraintsSettingAction(this._ext);
        }
        if ("EXT_PUBSH_WARNING".equals(name)) {
            return new PushAndWarningAction(this._ext);
        }
        if ("EXT_FI_PARAMS".equals(name)) {
            return new FIParamEditAction(this._ext);
        }
        if ("SAVE_AS_ENTERNAL_MACROS".equals(name)) {
            return new SaveAsExtenalMacrosAction(this._ext);
        }
        if ("CLEAR_EXT_MACROS_USEROBJECT".equals(name)) {
            return new ClearExtMacrosUserObjectAction(this._ext);
        }
        if ("EXT_CARD_SETTING".equals(name)) {
            return new CardLayoutAction(this._ext);
        }
        return null;
    }
}

