/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile.simui;

import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.AbstractDevice;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.device.DeviceFactory;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class Simulator {
    private static Logger logger = LogUtil.getPackageLogger(Simulator.class);
    private static int WIDTH_VIEWPORT_SCALE_TO = 320;
    private static int HEIGHT_STATUS_BAR = 20;
    private AbstractDevice _device;
    private MyUi _ui;
    private JComponent _webview;

    public Simulator() {
        this.init();
    }

    private void init() {
        this._ui = new MyUi();
    }

    public void setDevice(AbstractDevice device) {
        this._device = device;
        this.relayoutChildren();
    }

    private AbstractDevice getDevice() {
        if (this._device == null) {
            throw new RuntimeException("You must call setDevice() first.");
        }
        return this._device;
    }

    public void setWebview(JComponent webview, String title) {
        if (null != this._webview) {
            this._ui.remove(this._webview);
        }
        this._webview = webview;
        this._ui.add(webview);
        this.relayoutChildren();
    }

    public JComponent getUi() {
        return this._ui;
    }

    public JDialog createDialog(Component parent) {
        MyDialog dlg;
        Window win = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (win instanceof JDialog) {
            dlg = new MyDialog((JDialog)win);
        } else if (win instanceof JFrame) {
            dlg = new MyDialog((JFrame)win);
        } else {
            throw new RuntimeException("Unsupport.");
        }
        ((Window)((Object)dlg)).setSize(this.getDevice().getWindowWidth(), this.getDevice().getWindowHeight());
        ((Window)((Object)dlg)).setLocationRelativeTo(parent);
        Point p = ((Component)((Object)dlg)).getLocation();
        int x = p.x;
        int y = p.y;
        if (x <= 0) {
            x = (parent.getWidth() - ((Component)((Object)dlg)).getWidth()) / 2;
        }
        if (y <= 0) {
            y = 0;
        }
        ((Window)((Object)dlg)).setLocation(x, y);
        ((Dialog)((Object)dlg)).setUndecorated(true);
        ((JDialog)((Object)dlg)).getContentPane().setLayout(new BorderLayout());
        ((JDialog)((Object)dlg)).getContentPane().add((Component)this.getUi(), "Center");
        this.makeSureDialogInsideScope((JDialog)((Object)dlg), ((Component)((Object)dlg)).getX(), ((Component)((Object)dlg)).getY(), this.confirmScreenScope(null));
        CloseButton btnClose = new CloseButton((JDialog)((Object)dlg));
        btnClose.setLocation(this.getDevice().getWindowWidth() - 40, 0);
        btnClose.setSize(40, 40);
        this.getUi().add(btnClose);
        return dlg;
    }

    private int getStatusBarAndShellHeadHeight() {
        float totalHead = HEIGHT_STATUS_BAR;
        return (int)((double)(totalHead * (float)this.getDevice().getSimScreenWidth() / (float)WIDTH_VIEWPORT_SCALE_TO) + 0.5);
    }

    private void relayoutChildren() {
        if (this._webview == null || this._device == null) {
            return;
        }
        int headerHeight = this.getStatusBarAndShellHeadHeight();
        this._webview.setLocation(this._device.getSimScreenX(), this._device.getSimScreenY() + headerHeight);
        this._webview.setSize(this._device.getSimScreenWidth(), this._device.getSimScreenHeight() - headerHeight);
    }

    private BufferedImage captureScreen(int x, int y, int width, int height) {
        BufferedImage img;
        try {
            Robot robot = new Robot();
            img = robot.createScreenCapture(new Rectangle(x, y, width, height));
        }
        catch (AWTException ex) {
            logger.info((Object)"Capture screen error.", (Throwable)ex);
            img = null;
        }
        return img;
    }

    private int[] confirmScreenScope(Container parentWin) {
        Point rightBottom;
        Point leftTop;
        Container parent = parentWin instanceof JDialog ? ((JDialog)parentWin).getContentPane() : (parentWin instanceof JFrame ? ((JFrame)parentWin).getContentPane() : null);
        if (parent == null) {
            Rectangle pcScreen = WindowUtil.getDesktopBounds((GraphicsConfiguration)this._ui.getGraphicsConfiguration());
            leftTop = new Point(pcScreen.x, pcScreen.y);
            rightBottom = new Point(pcScreen.width - pcScreen.x, pcScreen.height - pcScreen.y);
        } else {
            leftTop = new Point(0, 0);
            rightBottom = new Point(0 + parent.getWidth(), 0 + parent.getHeight());
            SwingUtilities.convertPointToScreen(leftTop, parent);
            SwingUtilities.convertPointToScreen(rightBottom, parent);
        }
        return new int[]{leftTop.x, leftTop.y, rightBottom.x, rightBottom.y};
    }

    private void makeSureDialogInsideScope(JDialog dlg, int newX, int newY, int[] scope) {
        if (newX < scope[0]) {
            newX = scope[0];
        }
        if (newX + dlg.getWidth() > scope[2]) {
            newX = scope[2] - dlg.getWidth();
        }
        if (newY + dlg.getHeight() > scope[3]) {
            newY = scope[3] - dlg.getHeight();
        }
        if (newY < scope[1]) {
            newY = scope[1];
        }
        dlg.setLocation(newX, newY);
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        final KDFrame frame = new KDFrame();
        frame.setTitle("Mobile device simulator");
        frame.setSize(1024, 768);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        final KDComboBox cmbDevices = new KDComboBox((Object[])DeviceFactory.createAll());
        cmbDevices.setLocation(10, 10);
        cmbDevices.setSize(210, 21);
        KDWorkButton btnPreview = new KDWorkButton();
        btnPreview.setText("go go go...");
        btnPreview.setSize(72, 21);
        btnPreview.setLocation(10, 40);
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDevice device = (AbstractDevice)cmbDevices.getSelectedItem();
                JPanel asAWebview = new JPanel();
                asAWebview.setBackground(new Color(255, 255, 204));
                Simulator sim = new Simulator();
                sim.setDevice(device);
                sim.setWebview(asAWebview, null);
                JDialog dlg = sim.createDialog((Component)frame);
                dlg.setVisible(true);
            }
        });
        frame.getContentPane().setLayout(null);
        frame.getContentPane().add((Component)cmbDevices);
        frame.getContentPane().add((Component)btnPreview);
        frame.show();
    }

    private static class CloseButton
    extends JComponent {
        private boolean _isMouseCover;
        private boolean _isMousePressed;
        private Image _imgNormal;
        private Image _imgLight;
        private Image _imgPress;

        public CloseButton(JDialog dlg) {
            this.addMouseListener(new CloseButtonMouseHandler(dlg));
        }

        public void setMouseCover(boolean isCover) {
            if (this._isMouseCover != isCover) {
                this._isMouseCover = isCover;
                this.repaint();
            }
        }

        public void setMousePressed(boolean isPressed) {
            if (this._isMousePressed != isPressed) {
                this._isMousePressed = isPressed;
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Image img;
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            if (this._isMousePressed) {
                if (this._imgPress == null) {
                    this._imgPress = this.loadImage("img/btnClose_press.png");
                }
                img = this._imgPress;
            } else if (this._isMouseCover) {
                if (this._imgLight == null) {
                    this._imgLight = this.loadImage("img/btnClose_light.png");
                }
                img = this._imgLight;
            } else {
                if (this._imgNormal == null) {
                    this._imgNormal = this.loadImage("img/btnClose.png");
                }
                img = this._imgNormal;
            }
            if (img != null) {
                g2d.drawImage(img, 0, 0, w, h, null);
            } else {
                g2d.setColor(new Color(255, 204, 51));
                g2d.drawRoundRect(1, 1, w - 2, h - 2, w, h);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image loadImage(String imgName) {
            block5: {
                InputStream stm = Simulator.class.getResourceAsStream(imgName);
                if (stm != null) {
                    BufferedImage bufferedImage;
                    try {
                        bufferedImage = ImageIO.read(stm);
                    }
                    catch (IOException ex) {
                        try {
                            logger.error((Object)"", (Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{stm});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{stm});
                        break block5;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{stm});
                    return bufferedImage;
                }
                logger.error((Object)("Image '" + imgName + "' not exist."));
            }
            return null;
        }

        private class CloseButtonMouseHandler
        implements MouseListener {
            private JDialog _dlg;

            public CloseButtonMouseHandler(JDialog dlg) {
                this._dlg = dlg;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Object dlgObj = ((KDDialog)this._dlg).getUserObject();
                if (dlgObj instanceof JWebBrowser) {
                    JWebBrowser browser = (JWebBrowser)dlgObj;
                    Boolean isAlertShowing = (Boolean)browser.executeJavascriptWithResult("return window.isAlertShowing;");
                    if (isAlertShowing == null || !isAlertShowing.booleanValue()) {
                        this._dlg.dispose();
                    }
                    return;
                }
                this._dlg.dispose();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CloseButton.this.setMouseCover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CloseButton.this.setMouseCover(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CloseButton.this.setMousePressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CloseButton.this.setMousePressed(false);
            }
        }
    }

    private class MyDialog
    extends KDDialog {
        public MyDialog(JDialog parent) {
            super((Dialog)parent);
            this.init(parent);
        }

        public MyDialog(JFrame parent) {
            super((Frame)parent);
            this.init(parent);
        }

        private void init(Window parent) {
            DialogMouseHandler handler = new DialogMouseHandler();
            this.addMouseListener(handler);
            this.addMouseMotionListener(handler);
        }

        public void setVisible(boolean isVisible) {
            if (isVisible) {
                Simulator.this._ui.setScreenCaptureForBackground(Simulator.this.captureScreen(this.getX(), this.getY(), this.getWidth(), this.getHeight()));
            }
            super.setVisible(isVisible);
        }

        private class DialogMouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            private Point _mouseStart;
            private int[] _scope;
            private BufferedImage _fullScopeBackground;

            private DialogMouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getX() > Simulator.this._device.getSimScreenX() && e.getX() < Simulator.this._device.getSimScreenX() + Simulator.this._device.getSimScreenWidth() && e.getY() > Simulator.this._device.getSimScreenY() && e.getY() < Simulator.this._device.getSimScreenY() + Simulator.this._device.getSimScreenHeight()) {
                    return;
                }
                this._mouseStart = e.getPoint();
                this._scope = Simulator.this.confirmScreenScope(null);
                int h = MyDialog.this.getHeight();
                if (h > this._scope[3]) {
                    this._scope[3] = h;
                }
                this._fullScopeBackground = Simulator.this.captureScreen(this._scope[0], this._scope[1], this._scope[2] - this._scope[0], this._scope[3] - this._scope[1]);
                if (this._fullScopeBackground != null) {
                    BufferedImage subImg = Simulator.this._ui.getScreenCaptureForBackground();
                    Graphics2D g2d = this._fullScopeBackground.createGraphics();
                    int x = MyDialog.this.getX();
                    int y = MyDialog.this.getY();
                    int w = MyDialog.this.getWidth();
                    g2d.drawImage(subImg, x, y, w, h, null);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this._mouseStart != null) {
                    this.updateBackground();
                    this._fullScopeBackground = null;
                    this._mouseStart = null;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this._mouseStart == null) {
                    return;
                }
                Point current = e.getPoint();
                int deltaX = current.x - this._mouseStart.x;
                int deltaY = current.y - this._mouseStart.y;
                int newX = MyDialog.this.getX() + deltaX;
                int newY = MyDialog.this.getY() + deltaY;
                Simulator.this.makeSureDialogInsideScope((JDialog)((Object)MyDialog.this), newX, newY, this._scope);
                this.updateBackground();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            private void updateBackground() {
                if (this._fullScopeBackground != null) {
                    int x = MyDialog.this.getX();
                    int y = MyDialog.this.getY();
                    int w = MyDialog.this.getWidth();
                    int h = MyDialog.this.getHeight();
                    try {
                        Simulator.this._ui.setScreenCaptureForBackground(this._fullScopeBackground.getSubimage(x, y, w, h));
                    }
                    catch (RasterFormatException rfe) {
                        logger.warn((Object)"(y + height) is outside raster!");
                    }
                    Simulator.this._ui.repaint();
                }
            }
        }
    }

    private class MyUi
    extends JComponent {
        private Image _image;
        private BufferedImage _background;

        private MyUi() {
            this.setLayout(null);
        }

        public void setScreenCaptureForBackground(BufferedImage img) {
            this._background = img;
        }

        public BufferedImage getScreenCaptureForBackground() {
            return this._background;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AbstractDevice device = Simulator.this.getDevice();
            int w = device.getWindowWidth();
            int h = device.getWindowHeight();
            if (this._background == null) {
                g2d.clearRect(0, 0, w, h);
            } else {
                g2d.drawImage(this._background, 0, 0, w, h, null);
            }
            if (this._image == null) {
                this._image = device.getFace();
            }
            g2d.drawImage(this._image, 0, 0, w, h, null);
            int x = device.getSimScreenX();
            int y = device.getSimScreenY();
            w = device.getSimScreenWidth();
            if (device.isHasStatusBar()) {
                int statusBarHeight = (int)((double)((float)w / (float)WIDTH_VIEWPORT_SCALE_TO * (float)HEIGHT_STATUS_BAR) + 0.5);
                if ("roundRect".equals(device.getStatusBarShape())) {
                    this.paintStatusBar(g2d, x, y, w, statusBarHeight, statusBarHeight * 3, statusBarHeight);
                } else {
                    this.paintStatusBar(g2d, x, y, w, statusBarHeight, 0, 0);
                }
                y += statusBarHeight;
                g2d.setColor(Color.lightGray);
                g2d.drawLine(x, --y, x + w - 1, y);
            }
        }

        private void paintStatusBar(Graphics2D g2d, int x, int y, int w, int h, int arcWidth, int arcHeight) {
            if (arcWidth != 0) {
                g2d.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.1f));
                g2d.setColor(Color.black);
                g2d.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
                g2d.fillRect(x, y + h / 2, w, h / 2);
            } else {
                g2d.setBackground(Color.black);
                g2d.clearRect(x, y, w, h);
            }
            g2d.setColor(Color.white);
            int iconHeight = (int)((double)h * 0.6);
            int iconWidth = (int)((double)iconHeight * 1.5);
            int iconY = y + (h - iconHeight) / 2;
            int iconX = (int)((double)(x + w) - (double)iconWidth * 1.5);
            int rectY = iconY + 1;
            int rectX = iconX;
            int rectHeight = iconHeight - 2;
            int rectWidth = iconWidth - 2;
            g2d.drawRect(rectX, rectY, rectWidth, rectHeight);
            int headerHeight = rectHeight / 2;
            int headerY = rectY + (rectHeight - headerHeight) / 2;
            g2d.drawRect(rectX + rectWidth, headerY, 2, headerHeight);
            rectWidth = (int)((double)rectWidth * 0.5);
            g2d.drawRect(rectX += 2, rectY += 2, rectWidth, rectHeight -= 4);
            g2d.fillRect(rectX, rectY, rectWidth, rectHeight);
            iconX = (int)((double)iconX - (double)iconWidth * 1.3);
            int rectGap = 2;
            int rectBottom = iconY + iconHeight;
            int rectWidth2 = iconWidth / 4 - rectGap;
            int rectX2 = iconX;
            for (int i = 0; i < 4; ++i) {
                int rectHeight2 = iconHeight * (i + 1) / 4;
                g2d.fillRect(rectX2, rectBottom - rectHeight2, rectWidth2, rectHeight2);
                rectX2 += rectWidth2 + rectGap;
            }
        }
    }
}

