/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.model.runtime;

import com.kingdee.bos.ctrl.ext.reporting.model.UpdateType;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateProperty;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import java.util.ArrayList;
import java.util.List;

public class InsertDataPlan
extends ExecutionPlan {
    public InsertDataPlan(String identityKey, Cell[] usedCells, IUpdateConstraint constraint) {
        super(identityKey, usedCells, constraint);
    }

    @Override
    public void generateSQL() {
        int i;
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        ArrayList<Integer> jdbcList = new ArrayList<Integer>();
        ArrayList<Variant> variantList = new ArrayList<Variant>();
        ArrayList<String> cellList = new ArrayList<String>();
        ArrayList<Cell> cellRefList = new ArrayList<Cell>();
        StringBuilder values = new StringBuilder("VALUES (");
        sb.append(this._constraint.getProperty());
        sb.append(" (");
        List props = this._constraint.getUpdateProperties();
        for (i = 0; i < props.size(); ++i) {
            IUpdateProperty property = (IUpdateProperty)props.get(i);
            sb.append(property.getPropertyName());
            Cell cll = this.findSourceCell(property);
            cellRefList.add(cll);
            Sheet sheet = cll.getSheet();
            Expr expr = InsertDataPlan.parseExpr(property, sheet, cll);
            Variant v = expr.execute(sheet.getDeps().getExprContext(), cll);
            jdbcList.add(new Integer(property.getJdbcDataType()));
            variantList.add(v);
            cellList.add(expr.decode(sheet.getDeps().getExprContext(), cll));
            values.append("?");
            if (i != props.size() - 1) {
                sb.append(",");
                values.append(",");
                continue;
            }
            sb.append(") ");
            values.append(")");
        }
        sb.append(values.toString());
        this._jdbcTypes = new int[jdbcList.size()];
        for (i = 0; i < jdbcList.size(); ++i) {
            this._jdbcTypes[i] = (Integer)jdbcList.get(i);
        }
        this._values = variantList.toArray(new Variant[0]);
        this._sortedUsedFormulas = cellList.toArray(new String[0]);
        this._parsedCells = cellRefList.toArray(new Cell[0]);
        this._sql = sb.toString();
        if (this._constraint.getUpdateType() == UpdateType.PROCEDURE_UPDATE) {
            this._sql = "call procedure\u3010" + this._constraint.getProperty() + "\u3011to Insert data";
        }
    }

    public String toString() {
        return "\u6570\u636e\u65b0\u589e\u8ba1\u5212" + (this._isMerged ? "\u3010\u5408\u5e76\u7684\u64cd\u4f5c\u8bb0\u5f55\u3011" : "");
    }
}

