/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.subrpt.design;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.ext.subrpt.design.InsertSubRptAssembler;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;

public class WizzardSubReport
extends KDDialog
implements ISpreadWizzard {
    private static final long serialVersionUID = 1L;
    private SpreadContext _context;
    private InsertSubRptAssembler _subRptAssembler;
    private boolean _isCancel;

    public WizzardSubReport(Frame parent, SpreadContext context) {
        super(parent, true);
        this.init(context);
    }

    public WizzardSubReport(Dialog parent, SpreadContext context) {
        super(parent, true);
        this.init(context);
    }

    private void init(SpreadContext context) {
        this._context = context;
        this.initComponents();
    }

    private void initComponents() {
        this.setSize(600, 480);
        KDButton btnOk = new KDButton("\u786e\u5b9a");
        KDButton btnCancel = new KDButton("\u53d6\u6d88");
        KDPanel panelBtn = new KDPanel();
        panelBtn.setCustomInsets(new Insets(0, 0, 0, 10));
        TableLayout2 layout = new TableLayout2(1, 3);
        panelBtn.setLayout((LayoutManager)layout);
        layout.setFixedHeight(0, 22);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 70);
        layout.setFixedWidth(2, 70);
        layout.setColSpacing(1, 8);
        panelBtn.add((Component)btnOk, (Object)TableLayout2.param((int)0, (int)1));
        panelBtn.add((Component)btnCancel, (Object)TableLayout2.param((int)0, (int)2));
        layout = new TableLayout2(2, 1);
        layout.setRatableHeight(0, 1);
        layout.setFixedHeight(1, 27);
        this.setLayout((LayoutManager)layout);
        KDExt ext = (KDExt)((Object)SwingUtilities.getWindowAncestor((Component)((Object)this._context)));
        this._subRptAssembler = new InsertSubRptAssembler(ext);
        this.add((Component)((Object)this._subRptAssembler), TableLayout2.param((int)0, (int)0));
        this.add((Component)panelBtn, TableLayout2.param((int)1, (int)0));
        btnCancel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WizzardSubReport.this._isCancel = true;
                WizzardSubReport.this.setVisible(false);
                WizzardSubReport.this.dispose();
            }
        });
        btnOk.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WizzardSubReport.this._subRptAssembler.checkNullable()) {
                    WizzardSubReport.this._isCancel = false;
                    WizzardSubReport.this.setVisible(false);
                    WizzardSubReport.this.dispose();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WizzardSubReport.this._isCancel = true;
            }
        });
    }

    @Override
    public boolean prepare() {
        this._context.getStateManager().stop();
        Sheet sheet = this._context.getBook().getActiveSheet();
        Cell cell = sheet.getActiveCell();
        if (cell == null) {
            if (this._subRptAssembler != null) {
                this._subRptAssembler.clearData();
            }
            return true;
        }
        SubReportInfo rptInfo = cell.getSubReportInfo();
        if (rptInfo == null) {
            if (this._subRptAssembler != null) {
                this._subRptAssembler.clearData();
            }
            return true;
        }
        this._subRptAssembler.syncModel2UI(rptInfo);
        return true;
    }

    @Override
    public void commit() {
        int i;
        if (this._isCancel) {
            return;
        }
        SubReportInfo rptInfo = this._subRptAssembler.syncUI2Model();
        if (rptInfo == null) {
            return;
        }
        Book book = this._context.getBook();
        Sheet sheet = book.getActiveSheet();
        Range range = sheet.getSelectionRange();
        MergeBlocks merger = sheet.getMerger(false);
        book.getUndoManager().startGroup();
        if (merger == null) {
            range.merge();
        } else {
            for (i = range.size() - 1; i >= 0; --i) {
                Range tempRange = null;
                CellBlock rangeBlock = range.getBlock(i);
                SortedCellBlockArray mergeBlocks = merger.getTouchedBlocks(rangeBlock);
                if (mergeBlocks != null && !mergeBlocks.isEmpty()) {
                    if (mergeBlocks.size() == 1 && rangeBlock.equals(mergeBlocks.getBlock(0))) continue;
                    tempRange = new Range(book, sheet, rangeBlock);
                    tempRange.merge();
                }
                if (tempRange == null) {
                    tempRange = new Range(book, sheet, rangeBlock);
                }
                tempRange.merge();
            }
        }
        range.setSubReportInfo(rptInfo);
        for (i = range.size() - 1; i >= 0; --i) {
            CellBlock rangeBlock = range.getBlock(i);
            Cell cell = sheet.getActualCell(rangeBlock.getRow(), rangeBlock.getCol());
            sheet.addSubReportCell(cell);
        }
        book.getUndoManager().endGroup();
    }
}

