/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public abstract class AbstractChartPanel
extends KDPanel
implements IWizardStep {
    private static final long serialVersionUID = 1L;
    public static String prefix = "\u56fe\u8868\u5411\u5bfc\uff08\u5171\u516d\u6b65\uff09 ";
    protected IWizardStep next;
    protected IWizardStep last;
    protected String title;
    protected SpreadContext context;
    protected Container parent;
    protected FusionGraphicsModel model;

    protected AbstractChartPanel(IWizardStep last, SpreadContext context, Container parent, FusionGraphicsModel model) {
        this.last = last;
        this.context = context;
        this.parent = parent;
        this.model = model;
    }

    public void setModel(FusionGraphicsModel model) {
        this.model = model;
    }

    @Override
    public boolean checkValid() {
        return false;
    }

    @Override
    public IWizardStep getNextStep() {
        if (this.next == null) {
            this.initNextStep();
        }
        return this.next;
    }

    @Override
    public IWizardStep getPrevStep() {
        return this.last;
    }

    @Override
    public boolean prepare() {
        if (this.title != null) {
            if (this.parent instanceof Dialog) {
                ((Dialog)this.parent).setTitle(prefix + this.title);
            } else if (this.parent instanceof Frame) {
                ((Frame)this.parent).setTitle(this.title);
            }
        }
        return true;
    }

    public void dispose() {
        if (this.next != null) {
            ((AbstractChartPanel)this.next).dispose();
        }
    }

    protected abstract void initNextStep();

    public EmbedObject compose() {
        Sheet activeSheet = this.context.getBook().getActiveSheet();
        FusionChartDataNode dataNode = this.model.getDataNode();
        if (dataNode == null) {
            dataNode = new FusionChartDataNode(activeSheet);
            dataNode.setDataFrom(this.model.getDataFrom());
            dataNode.setChartType(this.model.getChartType());
        } else {
            Sheet srcSheet = dataNode.getSheet();
            int srcIndex = srcSheet.getSheetIndex();
            if (srcIndex != activeSheet.getSheetIndex()) {
                srcSheet.setSelected(true);
                activeSheet.setSelected(false);
                activeSheet = srcSheet;
                this.context.getBook().setActiveSheet(srcIndex);
            }
        }
        AbstractFusionBean bean = this.model.getBean();
        if (bean == null) {
            return null;
        }
        FlashChartModel chartModel = new FlashChartModel();
        chartModel.setDataNode(dataNode);
        chartModel.setChartType(this.model.getChartType());
        chartModel.setBean(bean);
        chartModel.setDataFrom(this.model.getDataFrom());
        chartModel.setExtTargets(this.model.getExtTargets());
        chartModel.setInnerTargets(this.model.getInnerTargets());
        chartModel.setFrameWorkType(this.model.getFramworkType());
        final EmbedhLayer layer = activeSheet.getEmbedments(true);
        int anchorMode = this.model.getAnchorMode();
        String anchorCellLT = this.model.getAnchorCellLT();
        String anchorCellRB = this.model.getAnchorCellRB();
        int x = this.model.getX();
        int y = this.model.getY();
        int w = this.model.getW();
        int h = this.model.getH();
        ChartRectEmbedment fc = null;
        fc = this.model.getFramworkType() == ChartFrameWorkType.ECHART ? new EChart(activeSheet, chartModel) : new FlashChart(activeSheet, chartModel);
        if (w != 0 && h != 0) {
            fc.setBounds(x, y, w, h);
        } else {
            SpreadView view = this.context.getSpread().getActiveView();
            Rectangle rect = view.getVisibleRect();
            rect = EChart.DEBUGMODE ? this.calcVisibleCentre(rect, 560, 660) : this.calcVisibleCentre(rect, 420, 278);
            rect.y = rect.y += layer.size() * 20;
            fc.setBounds(rect);
        }
        fc.setAnchorMode(anchorMode);
        if (anchorMode == 0) {
            fc.setAnchorCellLT(anchorCellLT);
            fc.setAnchorCellRB(anchorCellRB);
        } else if (anchorMode == 1) {
            fc.setAnchorCellLT(anchorCellLT);
        }
        String chartName = bean.getChartName();
        if (StringUtil.isEmptyString((String)chartName)) {
            chartName = "\u56fe\u8868" + (layer.size() + 1);
            bean.setChartName(chartName);
        }
        fc.setName(chartName);
        if (layer.hasSelection()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    layer.removeSelectedEmbeds();
                }
            });
        }
        layer.addEmbed(fc);
        return fc;
    }

    private Rectangle calcVisibleCentre(Rectangle rect, int w, int h) {
        Rectangle r = new Rectangle();
        r.x = (rect.width - w) / 2;
        r.y = (rect.height - h) / 2;
        r.height = h;
        r.width = w;
        return r;
    }

    public static void replaceUnSafeChar(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            values[i] = values[i].replaceAll("<", "&lt;");
            values[i] = values[i].replaceAll(">", "&gt;");
            values[i] = values[i].replaceAll("'", "&apos;");
            values[i] = values[i].replaceAll("\"", "&quot;");
        }
    }

    public static void repairUnSafeChar(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            values[i] = values[i].replaceAll("&lt;", "<");
            values[i] = values[i].replaceAll("&gt;", ">");
            values[i] = values[i].replaceAll("&apos;", "'");
            values[i] = values[i].replaceAll("&quot;", "\"");
        }
    }

    public abstract void syncModel2Graphics(int var1);

    public abstract boolean syncGraphics2Model(int var1);

    public abstract KDPanel getImpl();

    public abstract String getTitle();
}

