/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart;

import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.components.FlashPluginOptions;
import chrriis.dj.nativeswing.swtimpl.components.JFlashPlayer;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.FlashHelper;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.IExecuteableDisplayPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class FusionChartDisplayPanel
extends KDPanel
implements INativeEmbedment,
IExecuteableDisplayPanel {
    private static final long serialVersionUID = 1L;
    private JFlashPlayer player;
    private String xml;
    private FusionGraphicsModel model;
    private KDPopupMenu popMenu;
    private Container containerParent;

    public FusionChartDisplayPanel(Container parent) {
        this(parent, null);
    }

    public FusionChartDisplayPanel(Container parent, FusionGraphicsModel model) {
        this.containerParent = parent;
        this.model = model;
        this.popMenu = new KDPopupMenu();
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(new BorderLayout());
        this.initWebBrowser();
    }

    @Override
    public void setModel(FusionGraphicsModel model) {
        this.model = model;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    private void initWebBrowser() {
        MiscUtil.switchSWTLibSilently();
        this.player = new JFlashPlayer(FlashChart.createNSOptions());
        this.player.setSize(100, 50);
        this.add((Component)this.player);
        this.player.getWebBrowser().addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
                e.consume();
            }
        });
        PlayerListener playerListener = new PlayerListener();
        this.player.getNativeComponent().addMouseListener((MouseListener)playerListener);
        this.validate();
    }

    private boolean initXML() {
        String xmlStr = this.model.toXML();
        if (StringUtil.isEmptyString((String)xmlStr)) {
            return false;
        }
        String x = xmlStr.toLowerCase(Locale.ENGLISH);
        int index = x.indexOf("showaboutmenuitem='1'");
        if (index != -1) {
            x = x.substring(0, index) + " showaboutmenuitem='0' " + x.substring(index + 21);
        }
        if (x.equals(this.xml)) {
            return false;
        }
        this.xml = x;
        return true;
    }

    @Override
    public boolean execute() {
        return this.execute(true);
    }

    public boolean execute(boolean check) {
        if (this.player == null) {
            return false;
        }
        if (check && !this.initXML()) {
            return true;
        }
        FlashPluginOptions op = new FlashPluginOptions();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Width", "100%");
        map.put("Height", "100%");
        map.put("debugMode", "0");
        map.put("dataXML", this.xml);
        map.put("allowFullScreen", "true");
        op.setVariables(map);
        map = new HashMap();
        map.put("play", "0");
        map.put("scale ", "exactFit");
        map.put("wmode ", "transparent");
        op.setParameters(map);
        this.revalidate();
        this.player.load(FlashHelper.unpackSWF((Component)((Object)this), this.model.getChartType()), op);
        Thread executor = new Thread(){

            @Override
            public void run() {
                FusionChartDisplayPanel.this.player.doLayout();
                FusionChartDisplayPanel.this.player.validate();
                try {
                    Thread.sleep(80L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FusionChartDisplayPanel.this.player.stop();
                        FusionChartDisplayPanel.this.player.play();
                    }
                });
            }
        };
        executor.start();
        return true;
    }

    @Override
    public Component getNativeComponent() {
        if (null != this.player) {
            return this.player.getNativeComponent();
        }
        return null;
    }

    @Override
    public JComponent getDisplayPanel() {
        return this;
    }

    private class PlayerListener
    extends MouseAdapter {
        public PlayerListener() {
            KDMenuItem menuItem = new KDMenuItem();
            menuItem.setUI(null);
            KDWorkButton btnBefresh = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Refresh.gif"));
            btnBefresh.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FusionChartDisplayPanel.this.execute(false);
                }
            });
            btnBefresh.setToolTipText("\u5237\u65b0");
            menuItem.add((Component)btnBefresh);
            FusionChartDisplayPanel.this.popMenu.add((JMenuItem)menuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!FusionChartDisplayPanel.this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (FusionChartDisplayPanel.this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!FusionChartDisplayPanel.this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        public void showMenu() {
            NativeComponent parent = FusionChartDisplayPanel.this.player.getNativeComponent();
            int y = parent.getY();
            int x = parent.getX() + parent.getWidth() - 30;
            FusionChartDisplayPanel.this.popMenu.show((Component)parent, x, y);
            FusionChartDisplayPanel.this.popMenu.setVisible(true);
        }
    }
}

