/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.color;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.ExecuteableDisplayPanelAdpter;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.FusionChartWizzard;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.IExecuteableDisplayPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jdom2.Element;

class ColorEditor
extends KDDialog {
    private KDTable _colorTable;
    private KDComboBox _templateList;
    private KDButton _confirm;
    private KDButton _cancle;
    private KDWorkButton _insertRow;
    private KDWorkButton _deleteRow;
    private KDComboColor _colorSelector;
    private ColorTemplateVFPair _currentValue;
    private IExecuteableDisplayPanel _fdp;

    ColorEditor(Component parent, ColorTemplateVFPair value) {
        super((Dialog)((KDDialog)SwingUtilities.getWindowAncestor(parent)));
        this._currentValue = value;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("\u8bbe\u7f6e\u56fe\u8868\u989c\u8272\u65b9\u6848");
        this.setSize(670, 400);
        this.init();
    }

    private void init() {
        this._templateList = new KDComboBox((Object[])new String[]{ColorTemplateEditor.CUSTOM_TEMPLATE, ColorTemplateEditor.SYSTME_SCHEME_BUSINESS_TECHNOLOGY, ColorTemplateEditor.SYSTEM_SCHEME_NATURAL_COMFORT, ColorTemplateEditor.SYSTEM_SCHEME_FUN_INNOCENCE, ColorTemplateEditor.SYSTEM_SCHEME_HOT_SUMMER, ColorTemplateEditor.SYSTEM_SCHEME_DEFAULT});
        this._templateList.setBounds(10, 5, 150, 20);
        this._colorTable = new KDTable(2, 1, 0);
        this._colorTable.setBounds(10, 27, 270, 300);
        this._colorTable.getColumn(0).setWidth(100);
        this._colorTable.getColumn(1).setWidth(100);
        IRow headRow = this._colorTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)"\u540d\u79f0");
        headRow.getCell(1).setValue((Object)"\u503c");
        this._colorTable.getColumn(0).getStyleAttributes().setLocked(true);
        this._colorSelector = new KDComboColor();
        this._templateList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorEditor.this._insertRow.setVisible(false);
                ColorEditor.this._deleteRow.setVisible(false);
                switch (ColorEditor.this._templateList.getSelectedIndex()) {
                    case 0: {
                        if (ColorEditor.this._currentValue == null) break;
                        ColorEditor.this._insertRow.setVisible(true);
                        ColorEditor.this._deleteRow.setVisible(true);
                        String xml = ColorEditor.this._currentValue.getXmlValue();
                        int index = ColorEditor.this.getTemplateIndex(xml);
                        if (index != 0) break;
                        ColorEditor.this.parseXML(xml, false);
                        break;
                    }
                    case 1: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemSchemeBusinessTechnology(), false);
                        break;
                    }
                    case 2: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemSchemeNaturalComfort(), false);
                        break;
                    }
                    case 3: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemSchemeFunInnocence(), false);
                        break;
                    }
                    case 4: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemSchemeHotSummer(), false);
                        break;
                    }
                    case 5: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemSchemeDefault(), false);
                    }
                }
                ColorEditor.this.previewCurrentTemplate();
            }
        });
        this._colorTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this._colorSelector));
        IBasicRender renderer = new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                graphics.setColor((Color)object);
                Rectangle rect = clip.getBounds();
                graphics.fillRect(rect.x + 10, rect.y + 3, rect.width - 20, rect.height - 6);
            }
        };
        this._colorTable.getColumn(1).setRenderer(renderer);
        this._colorTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                ColorEditor.this.previewCurrentTemplate();
            }
        });
        this._colorSelector.addSelectedListener(new ComboColorSelectedListener(){

            public void selected(ComboColorSelectedEvent evt) {
                ColorEditor.this._colorTable.getEditManager().stopEditing();
            }
        });
        this._confirm = new KDButton("\u786e\u5b9a");
        this._confirm.setBounds(500, 340, 40, 20);
        this._confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this._currentValue = ColorEditor.this.serializeToXML();
                ColorEditor.this.dispose();
            }
        });
        this._cancle = new KDButton("\u53d6\u6d88");
        this._cancle.setBounds(580, 340, 40, 20);
        this._cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xml = ColorEditor.this._currentValue != null ? ColorEditor.this._currentValue.getXmlValue() : ColorTemplateEditor.getSystemSchemeDefault();
                ColorEditor.this.updateListSelectionIndex(xml);
                ColorEditor.this.dispose();
            }
        });
        this._insertRow = new KDWorkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = ColorEditor.this._colorTable.addRow();
                row.getCell(0).setValue((Object)"\u5faa\u73af\u8272\u503c");
                Color color = new Color(255, 255, 255);
                ColorEditor.this._colorSelector.setColor(null);
                row.getCell(1).setValue((Object)color);
            }
        });
        this._insertRow.setBounds(530, 5, 20, 20);
        this._insertRow.setFocusable(false);
        this._insertRow.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this._deleteRow = new KDWorkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)ColorEditor.this._colorTable);
                if (row != null) {
                    ColorEditor.this._colorTable.removeRow(row.getRowIndex());
                }
            }
        });
        this._deleteRow.setBounds(555, 5, 20, 20);
        this._deleteRow.setFocusable(false);
        this._deleteRow.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        Container c = this.getContentPane();
        c.setLayout(null);
        c.add((Component)this._templateList);
        c.add((Component)this._colorTable);
        c.add((Component)this._confirm);
        c.add((Component)this._cancle);
        c.add((Component)this._insertRow);
        c.add((Component)this._deleteRow);
        this._fdp = new ExecuteableDisplayPanelAdpter(FusionChartWizzard.model.getFramworkType(), null);
        this._fdp.getDisplayPanel().setBounds(280, 27, 375, 300);
        c.add(this._fdp.getDisplayPanel());
    }

    public void parseXML(String xmlString, boolean updateIndex) {
        if (updateIndex) {
            this.updateListSelectionIndex(xmlString);
        }
        this._colorTable.removeRows();
        try {
            Element root = XmlUtil.loadXmlString((String)xmlString);
            List contents = root.getContent();
            for (int i = 0; i < contents.size(); ++i) {
                Object next = contents.get(i);
                if (!(next instanceof Element) || !((Element)next).getName().equals("color")) continue;
                String value = ((Element)next).getAttributeValue("value");
                String red = value.substring(0, 2);
                String green = value.substring(2, 4);
                String blue = value.substring(4, 6);
                String alpha = value.substring(6, value.length());
                Color c = new Color(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16), Integer.parseInt(alpha));
                IRow row = this._colorTable.addRow();
                row.getCell(0).setValue((Object)"\u5faa\u73af\u8272\u503c");
                row.getCell(1).setValue((Object)c);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            MessageUtil.msgboxInfo((Component)this.getParent(), "\u521d\u59cb\u5316\u914d\u8272\u65b9\u6848\u51fa\u9519\uff01\u5c06\u4ee5\u9ed8\u8ba4\u65b9\u6848\u8fdb\u884c\u521d\u59cb\u5316\uff01", sw.toString());
        }
    }

    public void reShow() {
        if (this._fdp != null) {
            Container c = this.getContentPane();
            c.remove(this._fdp.getDisplayPanel());
            this._fdp = new ExecuteableDisplayPanelAdpter(FusionChartWizzard.model.getFramworkType(), null);
            this._fdp.getDisplayPanel().setBounds(280, 27, 375, 300);
            c.add(this._fdp.getDisplayPanel());
        }
        String xml = this.previewCurrentTemplate();
        this.updateListSelectionIndex(xml);
    }

    public String getText() {
        return (String)this._templateList.getSelectedItem();
    }

    public ColorTemplateVFPair getValue() {
        return this._currentValue;
    }

    private ColorTemplateVFPair serializeToXML() {
        StringBuilder sb = new StringBuilder("<template>");
        for (int i = 0; i < this._colorTable.getRowCount(); ++i) {
            IRow row = this._colorTable.getRow(i);
            Color c = (Color)row.getCell(1).getValue();
            String red = Integer.toString(c.getRed(), 16);
            String green = Integer.toString(c.getGreen(), 16);
            String blue = Integer.toString(c.getBlue(), 16);
            String alpha = String.valueOf(c.getAlpha());
            sb.append("<color value=\"");
            if (red.length() == 1) {
                sb.append("0");
            }
            sb.append(red);
            if (green.length() == 1) {
                sb.append("0");
            }
            sb.append(green);
            if (blue.length() == 1) {
                sb.append("0");
            }
            sb.append(blue);
            sb.append(alpha);
            sb.append("\"/>");
        }
        sb.append("</template>");
        String xml = sb.toString();
        return new ColorTemplateVFPair(this._currentValue == null ? null : this._currentValue.getBean(), xml);
    }

    private String previewCurrentTemplate() {
        FusionGraphicsModel smodel = new FusionGraphicsModel();
        smodel.setColorDemo(true);
        AbstractFusionBean bean = this._currentValue.getBean();
        ColorTemplateVFPair cbean = this.serializeToXML();
        bean.setChartColorTemplate(cbean);
        smodel.setChartType(bean.getChartType());
        smodel.setBean(bean);
        this._fdp.setModel(smodel);
        this._fdp.execute();
        return cbean.getXmlValue();
    }

    private void updateListSelectionIndex(String xml) {
        int index = this.getTemplateIndex(xml);
        this._insertRow.setVisible(index == 0);
        this._deleteRow.setVisible(index == 0);
        this._templateList.setSelectedIndex(index);
    }

    private int getTemplateIndex(String xml) {
        if (ColorTemplateEditor.getSystemSchemeBusinessTechnology().equalsIgnoreCase(xml)) {
            return 1;
        }
        if (ColorTemplateEditor.getSystemSchemeNaturalComfort().equalsIgnoreCase(xml)) {
            return 2;
        }
        if (ColorTemplateEditor.getSystemSchemeFunInnocence().equalsIgnoreCase(xml)) {
            return 3;
        }
        if (ColorTemplateEditor.getSystemSchemeHotSummer().equalsIgnoreCase(xml)) {
            return 4;
        }
        if (ColorTemplateEditor.getSystemSchemeDefault().equalsIgnoreCase(xml)) {
            return 5;
        }
        return 0;
    }
}

