/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.column;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.column.MSColumn2DBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StackedMSColumn2DBean
extends MSColumn2DBean {
    public StackedMSColumn2DBean(ChartFrameWorkType type) {
        this();
        if (ChartFrameWorkType.ECHART == type) {
            this.chart_chartTopMargin = "35";
            this.chart_chartBottomMargin = "50";
            this.chart_chartLeftMargin = "60";
            this.chart_chartRightMargin = "35";
        }
    }

    public StackedMSColumn2DBean() {
        this.chartType = FlashChartType.FLASH_CT_ST_MS_COL2D;
        this.isHyperLinkEnabled = false;
        this.chart_canvasBorderAlpha = new BooleanVFPair(true, null);
        this.chart_showLabels = new BooleanVFPair(true, null);
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.applyNumberFormats();
        String[] yAxisSettings = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_RIGHT_YAXIS_SETTINGS));
        if (yAxisSettings != null && yAxisSettings.length > 0) {
            this.chart.sNumberSuffix = yAxisSettings[0];
            this.chart.SYAxisName = yAxisSettings[1];
        }
        this.chart.setAttribute("showLegend", "1");
        if ("dataset".equals(dataNode.getDataFrom())) {
            this.fillChartNodesByDataset(dataNode);
        } else {
            this.fillChartNodesByCell(dataNode);
        }
    }

    protected void fillChartNodesByCell(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.applyNumberFormats();
        boolean isSeriesByCol = dataNode.isSerialByCol();
        String[] seriesFormulas = (String[])dataNode.getFormula(FusionChartDataNode.COMBINATION_CHART_SERIES_FORMULA);
        String[] groups = this.parseStrings(dataNode, dataNode.getGroupFormula());
        String[][] series = this.parseStrings(dataNode, seriesFormulas);
        Object[] dataValues = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
        String[] dataFormulas = (String[])dataNode.getFormula(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
        int gLen = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[gLen];
        for (int i = 0; i < gLen; ++i) {
            Categories.Category category = new Categories.Category();
            category.label = groups[i];
            this.categories.categories[i] = category;
        }
        Sheet sheet = dataNode.getSheet();
        int dLen = dataFormulas.length;
        this.datasets = new Dataset[series.length];
        for (int i = 0; i < dLen; ++i) {
            CellBlockNode block = SheetBaseMath.getArrayBlockNodes(sheet, dataFormulas[i], sheet.getBook().getDeps().isA1Style())[0];
            Variant[][] values = (Variant[][])dataValues[i];
            int row = series[i].length;
            int col = isSeriesByCol ? values.length : values[0].length;
            this.datasets[i] = new Dataset();
            this.datasets[i].dataset = new Dataset[row];
            for (int r = 0; r < row; ++r) {
                this.datasets[i].dataset[r] = new Dataset();
                this.datasets[i].dataset[r].seriesName = series[i][r];
                this.datasets[i].dataset[r].nodes = new NodeFunc[col];
                for (int c = 0; c < col; ++c) {
                    Set set = new Set();
                    set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(isSeriesByCol ? values[c][r].toBigDecimal().doubleValue() : values[r][c].toBigDecimal().doubleValue())) : String.valueOf(isSeriesByCol ? values[c][r].toBigDecimal().doubleValue() : values[r][c].toBigDecimal().doubleValue());
                    set.setCellRef(block.getSheet().getCell(block.getRow() + r, block.getCol() + c, true).getName(false, false));
                    this.datasets[i].dataset[r].nodes[c] = set;
                    set.link = this.buildLinkProp(groups[c], series[i][r], String.valueOf(isSeriesByCol ? values[c][r].toBigDecimal().doubleValue() : values[r][c].toBigDecimal().doubleValue()));
                }
            }
        }
    }

    protected void fillChartNodesByDataset(FusionChartDataNode dataNode) throws SyntaxErrorException {
        String[] groups = dataNode.getGroupKeys();
        Object[] dataValues = (Object[])dataNode.getData();
        Object[] seriesNames = (Object[])dataNode.getSeriesKeys();
        int lenGroup = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[lenGroup];
        for (int i = 0; i < lenGroup; ++i) {
            Categories.Category category = new Categories.Category();
            category.label = groups[i];
            this.categories.categories[i] = category;
        }
        int col = lenGroup;
        int lenSeries = seriesNames.length;
        this.datasets = new Dataset[lenSeries];
        for (int i = 0; i < lenSeries; ++i) {
            double[][] values = (double[][])dataValues[i];
            String[] series = (String[])seriesNames[i];
            int row = series.length;
            this.datasets[i] = new Dataset();
            this.datasets[i].dataset = new Dataset[row];
            for (int r = 0; r < row; ++r) {
                this.datasets[i].dataset[r] = new Dataset();
                this.datasets[i].dataset[r].seriesName = series[r];
                this.datasets[i].dataset[r].nodes = new NodeFunc[col];
                for (int c = 0; c < col; ++c) {
                    Set set = new Set();
                    set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[r][c])) : String.valueOf(values[r][c]);
                    this.datasets[i].dataset[r].nodes[c] = set;
                    set.link = this.buildLinkProp(groups[c], series[r], set.value);
                }
            }
        }
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
        int datasetSize = this.datasets.length;
        int index = hyperLinks[0].indexOf("[cell]");
        int index2 = index + 6;
        for (int i = 0; i < datasetSize; ++i) {
            int childSize = this.datasets[i].dataset.length;
            for (int j = 0; j < childSize; ++j) {
                int nodesSize = this.datasets[i].dataset[j].nodes.length;
                for (int k = 0; k < nodesSize; ++k) {
                    if (this.datasets[i].dataset[j].nodes[k].getCellRef() == null) continue;
                    ((Set)this.datasets[i].dataset[j].nodes[k]).link = Utils.encodeURL((String)(hyperLinks[0].substring(0, index) + "[" + this.datasets[i].dataset[j].nodes[k].getCellRef() + "]" + hyperLinks[0].substring(index2)));
                }
            }
        }
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        String ret = null;
        int group = this.datasets.length;
        switch (bindingPolicy) {
            case 2: {
                ret = cell;
                break;
            }
            case 0: {
                for (int i = 0; i < group; ++i) {
                    int n = this.datasets[i].dataset.length;
                    for (int j = 0; j < n; ++j) {
                        int n1 = this.datasets[i].dataset[j].nodes.length;
                        for (int k = 0; k < n1; ++k) {
                            if (!cell.equals(this.datasets[i].dataset[j].nodes[k].getCellRef())) continue;
                            return "G" + j + k;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < group; ++i) {
                    int n = this.datasets[i].dataset.length;
                    for (int j = 0; j < n; ++j) {
                        int n1 = this.datasets[i].dataset[j].nodes.length;
                        for (int k = 0; k < n1; ++k) {
                            if (!cell.equals(this.datasets[i].dataset[j].getCellRef())) continue;
                            return "S" + i + k;
                        }
                    }
                }
                break;
            }
        }
        return ret;
    }

    private String[] parseStrings(FusionChartDataNode dataNode, String formulas) {
        Variant[][] values = dataNode.calcExpr(dataNode, formulas);
        int row = values.length;
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < row; ++i) {
            int col = values[i].length;
            for (int j = 0; j < col; ++j) {
                ret.add(values[i][j].toString());
            }
        }
        String[] str = new String[ret.size()];
        ret.toArray(str);
        return str;
    }

    private String[][] parseStrings(FusionChartDataNode dataNode, String[] formulas) {
        int len = formulas.length;
        String[][] series = new String[len][];
        for (int k = 0; k < len; ++k) {
            Variant[][] values = dataNode.calcExpr(dataNode, formulas[k]);
            int row = values.length;
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < row; ++i) {
                int col = values[i].length;
                for (int j = 0; j < col; ++j) {
                    ret.add(values[i][j].toString());
                }
            }
            String[] str = new String[ret.size()];
            ret.toArray(str);
            series[k] = str;
        }
        return series;
    }

    @Override
    public String getDemoXML(List colors, HashMap numberFormats) {
        StringBuilder sb = new StringBuilder(StackedMSColumn2DBean.generateCommonDemoChartTtile("StMSCol2D", numberFormats));
        sb.append("<categories>");
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            sb.append("<category label='\u5206\u7ec4");
            sb.append(i + 1);
            sb.append("' />");
            sb2.append("<dataset>");
            int k = 0;
            int len = colors.size() / 2;
            if (i == 1) {
                k = len;
                len = colors.size();
            }
            while (k < len) {
                String nextColor = (String)colors.get(k);
                String color = nextColor.substring(0, 6);
                String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
                sb2.append("<dataset seriesName='\u7cfb\u5217");
                sb2.append(k + 1);
                sb2.append("' color='");
                sb2.append(color);
                sb2.append("' alpha='");
                sb2.append(alpha);
                sb2.append("' >");
                for (int j = 0; j < 2; ++j) {
                    sb2.append("<set value='");
                    sb2.append(Math.random() * 100.0);
                    sb2.append("' />");
                }
                sb2.append("</dataset>");
                ++k;
            }
            sb2.append("</dataset>");
        }
        sb.append("</categories>");
        sb.append(sb2.toString());
        sb.append("</chart>");
        return sb.toString();
    }
}

