/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableDocument;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.editor.InsideCollapsedException;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Logger;

class UndoableChanging
extends AbstractUndoableEdit {
    private static final Logger log = LogUtil.getLogger(UndoableChanging.class);
    public static final int REMOVE = 1;
    public static final int INSERT = 2;
    public static final int REPLACE = 3;
    private FuncCollapsableDocument _doc;
    private int _type;
    private int _posAtText;
    private String _removeStr;
    private String _insertStr;

    public static UndoableChanging createRemove(FuncCollapsableDocument doc, int posAtText, String str) {
        return new UndoableChanging(doc, 1, posAtText, str == null ? "" : str, null);
    }

    public static UndoableChanging createInsert(FuncCollapsableDocument doc, int posAtText, String str) {
        return new UndoableChanging(doc, 2, posAtText, null, str == null ? "" : str);
    }

    public static UndoableChanging createReplace(FuncCollapsableDocument doc, int posAtText, String removeStr, String insertStr) {
        return new UndoableChanging(doc, 3, posAtText, removeStr == null ? "" : removeStr, insertStr == null ? "" : insertStr);
    }

    private UndoableChanging(FuncCollapsableDocument doc, int type, int posAtText, String removeStr, String insertStr) {
        this._doc = doc;
        this._type = type;
        this._posAtText = posAtText;
        this._removeStr = removeStr;
        this._insertStr = insertStr;
    }

    private boolean isInsert() {
        return (this._type & 2) == 2;
    }

    private boolean isRemove() {
        return (this._type & 1) == 1;
    }

    @Override
    public boolean canUndo() {
        if (super.canUndo()) {
            int pos = 0;
            boolean continueExpand = true;
            boolean abort = false;
            while (continueExpand) {
                continueExpand = false;
                try {
                    pos = this._doc.changeTextPos2EditorPos(this._posAtText);
                }
                catch (InsideCollapsedException ex) {
                    abort = true;
                    continueExpand = true;
                    FuncCollapsableDocument.logDebug("\u64a4\u6d88\u5185\u5bb9\u5728\u6536\u8d77\u57df\u4e2d\uff0c\u5c55\u5f00: ", ex.getFunc());
                    this._doc.expandFuncUnit(ex.getFunc());
                }
            }
            if (abort) {
                if (this.isInsert()) {
                    pos += this._insertStr.length();
                }
                this._doc.getCtrlDependency().setCaretPosition(pos);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void undo() throws CannotUndoException {
        int pos;
        FuncCollapsableDocument.logDebug("Undo: ", this);
        try {
            pos = this._doc.changeTextPos2EditorPos(this._posAtText);
        }
        catch (InsideCollapsedException ex) {
            log.error((Object)"", (Throwable)ex);
            throw new CannotUndoException();
        }
        try {
            this._doc.closeUndoable();
            if (this.isInsert()) {
                this._doc.remove(pos, this._insertStr.length());
            }
            if (this.isRemove()) {
                this._doc.insertString(pos, this._removeStr, null);
                pos += this._removeStr.length();
            }
            this._doc.getCtrlDependency().setCaretPosition(pos);
        }
        catch (BadLocationException ex) {
            log.error((Object)("Undo: " + this.toString()), (Throwable)ex);
            throw new CannotUndoException();
        }
        finally {
            this._doc.openUndoable();
            super.undo();
        }
    }

    @Override
    public boolean canRedo() {
        if (super.canRedo()) {
            int pos = 0;
            boolean continueExpand = true;
            boolean abort = false;
            while (continueExpand) {
                continueExpand = false;
                try {
                    pos = this._doc.changeTextPos2EditorPos(this._posAtText);
                }
                catch (InsideCollapsedException ex) {
                    abort = true;
                    continueExpand = true;
                    FuncCollapsableDocument.logDebug("\u91cd\u505a\u5185\u5bb9\u5728\u6536\u8d77\u57df\u4e2d\uff0c\u5c55\u5f00: ", ex.getFunc());
                    this._doc.expandFuncUnit(ex.getFunc());
                }
            }
            if (abort) {
                if (this.isRemove()) {
                    pos += this._removeStr.length();
                }
                this._doc.getCtrlDependency().setCaretPosition(pos);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void redo() throws CannotRedoException {
        int pos;
        FuncCollapsableDocument.logDebug("Redo: ", this);
        try {
            pos = this._doc.changeTextPos2EditorPos(this._posAtText);
        }
        catch (InsideCollapsedException ex) {
            log.error((Object)"", (Throwable)ex);
            throw new CannotRedoException();
        }
        try {
            this._doc.closeUndoable();
            if (this.isRemove()) {
                this._doc.remove(pos, this._removeStr.length());
            }
            if (this.isInsert()) {
                this._doc.insertString(pos, this._insertStr, null);
                pos += this._insertStr.length();
            }
            this._doc.getCtrlDependency().setCaretPosition(pos);
        }
        catch (BadLocationException ex) {
            log.error((Object)("Rndo: " + this.toString()), (Throwable)ex);
            throw new CannotRedoException();
        }
        finally {
            this._doc.openUndoable();
            super.redo();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[\u53ef\u64a4\u6d88\u7684\u64cd\u4f5c] \u5728");
        sb.append(this._posAtText);
        if (this.isRemove()) {
            sb.append("\u5220\u9664:");
            sb.append(this._removeStr);
        }
        if (this.isInsert()) {
            if (this.isRemove()) {
                sb.append("\u3000\u540c\u65f6");
            }
            sb.append("\u63d2\u5165:");
            sb.append(this._insertStr);
        }
        return sb.toString();
    }
}

