/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.StyleDisplayPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.designer.StyleEditPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.StyleModelMannager;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleDescriptionModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleFileModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableStyleModel;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.io.File;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MobileWizardStyleDesigner {
    private KDFrame mainFrame;
    public static final String DEFAULT_STYLE_NAME = "lightGray";
    public static final String DEFAULT_STYLE_PIC = "lightGray/lightGray.png";
    public static final String DEFAULT_STYLE_FILE_PATH = "lightGray/lightGray.json";
    public static final String STYLE_STORE_DIR;
    public static final boolean DEBUG;
    public static final int VIEW_PART_NUM = 4;
    public static final String LIST_STYLE_NAME = "example_list_";
    public static final String GROUP_STYLE_NAME = "example_group_";
    public static final String SEGMENTLIST_STYLE_NAME = "example_segmentlist_";
    public static final String SEGMENTGROUP_STYLE_NAME = "example_segmentgroup_";
    public static final String MOBLIE_LIST_STYLE_NAME = "mobile_list_";
    public static final String MOBLIE_GROUP_STYLE_NAME = "mobile_group_";
    public static final String MOBLIE_SEGMENTLIST_STYLE_NAME = "mobile_segmentlist_";
    public static final String MOBLIE_SEGMENTGROUP_STYLE_NAME = "mobile_segmentgroup_";
    public static final String IMAGE_TYPE = ".png";
    public static final double TUMB_SCALE = 0.55;
    public static final double TUMB_MOBILE_SCALE = 1.22;

    public MobileWizardStyleDesigner() {
        this.init();
        this.mainFrame.show();
    }

    private void init() {
        KingdeeLookAndFeel.setCurrentTheme((int)10);
        try {
            UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.mainFrame = new KDFrame("\u62a5\u8868\u6837\u5f0f\u5411\u5bfc\u7f16\u8f91\u5668\u3002");
        this.mainFrame.setLayout((LayoutManager)new BorderLayout());
        TableStyleFileModel fileModel = this.loadStyles();
        StyleDisplayPanel displayPanel = new StyleDisplayPanel(StyleModelMannager.INSTANCE.geTableStyleModel(DEFAULT_STYLE_NAME));
        StyleEditPanel editPanel = new StyleEditPanel(fileModel, this.mainFrame, displayPanel, this);
        this.mainFrame.add((Component)((Object)editPanel), (Object)"East");
        this.mainFrame.add((Component)((Object)displayPanel), (Object)"West");
        this.mainFrame.setSize(1245, 750);
        int screentWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screentHight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.mainFrame.setLocation((screentWidth - this.mainFrame.getSize().width) / 2, (screentHight - this.mainFrame.getSize().height) / 2);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setResizable(false);
        this.mainFrame.setVisible(true);
    }

    public TableStyleFileModel loadStyles() {
        return StyleModelMannager.INSTANCE.getFileModel();
    }

    public void saveStyles(TableStyleFileModel styleFileModel) {
        File modelFile = new File(STYLE_STORE_DIR + File.separator + "tableStyles.json");
        try {
            FileUtil.writeFile((String)modelFile.getAbsolutePath(), (byte[])JSON.toJSONString((Object)styleFileModel, (boolean)true).getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, TableStyleDescriptionModel> node : styleFileModel.getTableStyleMap().entrySet()) {
            TableStyleDescriptionModel descriptionModel = node.getValue();
            TableStyleModel styleModel = descriptionModel.getLoadedStyle();
            if (null == styleModel) continue;
            String jsonStr = JSON.toJSONString((Object)styleModel, (boolean)true);
            File styleFile = new File(STYLE_STORE_DIR + File.separator + descriptionModel.getStyleFilePath());
            try {
                FileUtil.writeFile((String)styleFile.getAbsolutePath(), (byte[])jsonStr.getBytes("UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Image createScreenShoot(Point p1, Point p2) {
        return this.createScreenShoot((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
    }

    public Image createScreenShoot(int x1, int y1, int x2, int y2) {
        try {
            Robot robot = new Robot();
            Rectangle area = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            if (DEBUG) {
                System.out.println(area);
            }
            return robot.createScreenCapture(area);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        new MobileWizardStyleDesigner();
    }

    static {
        DEBUG = Boolean.parseBoolean(System.getProperty("dev.mode", "false"));
        STYLE_STORE_DIR = DEBUG ? System.getProperty("user.dir") + "/src/com/kingdee/bos/ctrl/ext/ui/wizards/mobile/icons/" : System.getProperty("user.dir") + "/com/kingdee/bos/ctrl/ext/ui/wizards/mobile/icons/";
        File file = new File(STYLE_STORE_DIR);
        file.mkdirs();
    }
}

