/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step;

import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.AbstractMobileReportWizardStep;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.MobileReportWizzardFinished;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.ReportFormatAndColorSchemeChooser;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.step.TableComposer;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.ui.ChartComposerPanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import javax.swing.JComponent;

public class ChartComposer
extends AbstractMobileReportWizardStep {
    private DatasetImporter importerPanel;
    private ChartComposerPanel chartComposerPanel = new ChartComposerPanel();
    private int index;
    private ReportType reportType;

    public ChartComposer(KDExt ext, MobileReportWizardModel model, int index) {
        super(ext, model);
        this.index = index;
    }

    public JComponent getContent() {
        return this.chartComposerPanel;
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        super.initStep(manager);
        ReportFormatAndColorSchemeChooser rt = (ReportFormatAndColorSchemeChooser)manager.getWizardDialog().getStepsList().get(0);
        this.importerPanel = rt.getImporterPanel();
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        this.reportType = this.model.getReportType();
        this.chartComposerPanel.initComps(this.ext, this.model, this.importerPanel, this.index);
    }

    public IWizardStep outThisStep(boolean isOppose) {
        FusionGraphicsModel fusionGraphicsModel = this.model.getChartModel().getFusionGraphicsModelList().get(this.index);
        fusionGraphicsModel.setDataFrom("dataset");
        DataFromDataset fromDataset = new DataFromDataset();
        this.chartComposerPanel.getChartKindOf().syncUI2Model(fromDataset);
        FusionChartDataNode node = fusionGraphicsModel.getDataNode();
        node.setFromDataset(fromDataset);
        AbstractFusionBean bean = fusionGraphicsModel.getBean();
        bean.setChartTitle(this.chartComposerPanel.getChartTitle());
        if (ReportType.CHART == this.reportType && !isOppose && this.index == this.model.getChartModel().getFusionGraphicsModelList().size() - 1) {
            return new MobileReportWizzardFinished(this.ext, this.model);
        }
        if (ReportType.CHARTTABLE == this.reportType) {
            return new TableComposer(this.ext, this.model);
        }
        return null;
    }

    @Override
    public void destroy(boolean isFinished) {
        this.chartComposerPanel.setChartComposerPanel(false);
    }
}

