/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.RenderUtil;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.core.SpreadViewUI;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

final class ColHeaderUI
extends SpreadViewUI {
    private static ColHeaderUI columnHeaderUI = new ColHeaderUI();
    private SpreadView _view;
    private Graphics2D _g2d;
    private Sheet _sheet;
    private int _sizeOfCols;
    private SpreadView.ColBuffer[] _cbs;
    private int _cinx;
    private int _cinx2;

    ColHeaderUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return columnHeaderUI;
    }

    @Override
    protected void installDefaults(SpreadView view) {
        view.setAutoscrolls(true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SpreadView view = (SpreadView)c;
        int h = view.getSpread().getBook().getActiveSheet().getColHeaderHeight();
        return new Dimension(view.getPreferredWidth(), h);
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        int i;
        this._g2d = g;
        this._view = view;
        this._sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = this._g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cCol = SheetBaseMath.colAtPoint(this._sheet, upperLeft);
        int cCol2 = SheetBaseMath.colAtPoint(this._sheet, lowerRight);
        if (cCol < 0) {
            return false;
        }
        cCol2 = SheetBaseMath.dealInvalidCol(cCol2);
        this._cbs = this._view.getColBuffers(cCol, cCol2);
        if (this._cbs == null) {
            return false;
        }
        this._sizeOfCols = this._cbs.length;
        for (i = 0; i < this._sizeOfCols; ++i) {
            if (cCol > this._cbs[i].getCol()) continue;
            this._cinx = i;
            break;
        }
        for (i = this._sizeOfCols - 1; i >= 0; --i) {
            if (cCol2 < this._cbs[i].getCol()) continue;
            this._cinx2 = i;
            break;
        }
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g2d, SpreadView view) {
        Rectangle clip = g2d.getClipBounds();
        g2d.setBackground(view.getBackground());
        g2d.clearRect(clip.x, clip.y, clip.width, clip.height);
        this.paintImpl();
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
        this._view = null;
        this._g2d = null;
        this._cbs = null;
        this._sheet = null;
    }

    private int calcLastCol() {
        if (this._cinx > 0) {
            return this._cbs[this._cinx - 1].getCol();
        }
        int temp = this._cbs[this._cinx].getCol();
        if (temp == 0) {
            return -1;
        }
        int index = this._sheet.getColSpans().searchSpan(temp - 1);
        if (index < 0 || this._sheet.getColSpans().getAttributeSpan(index).isVisible()) {
            return temp - 1;
        }
        return temp - 2;
    }

    private void paintImpl() {
        int lastCol = this.calcLastCol();
        int y = 0;
        int h = this._sheet.getColHeaderHeight();
        int y2 = h - 1;
        int spacing = SheetBaseMath.getColSpacing();
        Rectangle rect = new Rectangle();
        int maxCol = -1;
        boolean isMobile = this._sheet.getBook().is4Mobile();
        if (isMobile) {
            maxCol = this._sheet.getMaxColIndex();
        }
        for (int cIndex = this._cinx; cIndex <= this._cinx2; ++cIndex) {
            SpreadView.ColBuffer cb = this._cbs[cIndex];
            int col = cb.getCol();
            int width = cb.getColWidth();
            int x = cb.getColX();
            rect.setBounds(x, y, width + spacing, h);
            this._g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
            if (col > lastCol + 1) {
                this._g2d.fillRect(x, y, 1, h);
            }
            this._g2d.fillRect(x - 1, y, 1, h);
            String txt = SheetBaseMath.getColumnName(this._sheet, col);
            RenderUtil.paintHeaderContent(this._g2d, this._sheet, txt, rect);
            EmbedhLayer gl = this._sheet.getEmbedments(false);
            if (gl == null || !gl.hasSelection()) {
                RenderUtil.paintHeaderBackground(this._g2d, this._sheet.getSheetOption().getSelection().getSelectModeAtCol(col), rect);
            }
            RenderUtil.paintRptContentHeaderArea(this._g2d, rect, isMobile, maxCol, col);
            lastCol = col;
        }
        this._g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        SpreadView.ColBuffer cb = this._cbs[this._cinx];
        SpreadView.ColBuffer cb2 = this._cbs[this._cinx2];
        this._g2d.fillRect(cb2.getColX() + cb2.getColWidth() + 1, y, 1, h);
        this._g2d.fillRect(cb.getColX(), y, cb2.getColX() + cb2.getColWidth() - cb.getColX() + 1, 1);
        this._g2d.fillRect(cb.getColX(), y2, cb2.getColX() + cb2.getColWidth() - cb.getColX() + 1, 1);
    }
}

