/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.IMouseController;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.core.OutlineGroupColTagBarUI;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;

public class OutlineGroupColTagBar
extends SpreadView {
    private NumberButton[] nbs = new NumberButton[17];

    public OutlineGroupColTagBar(KDSpread spread) {
        for (int i = 0; i < this.nbs.length; ++i) {
            this.nbs[i] = new NumberButton(i + 1);
        }
        this._spread = spread;
        this.updateUI();
        this.init();
    }

    private void init() {
        this.setLayout(new ColTagBarLayoutManager());
        for (int i = 0; i < this.nbs.length; ++i) {
            this.add(this.nbs[i]);
        }
    }

    @Override
    public IMouseController getMouseController() {
        return null;
    }

    @Override
    public void updateUI() {
        this.setUI(OutlineGroupColTagBarUI.createUI(this));
    }

    @Override
    public int getViewType() {
        return 6;
    }

    @Override
    public void scrollCellVisible(int row, int col) {
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        super.setLayout(mgr);
    }

    private class NumberButton
    extends AbstractButton {
        private Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        private Border raisedBorder = BorderFactory.createRaisedBevelBorder();
        private int number = 0;

        private NumberButton(int number) {
            this.setModel(new DefaultButtonModel());
            this.installListeners();
            this.setFont(new Font("Dialog", 0, 10));
            this.number = number;
            this.setText(new Integer(number).toString());
        }

        private void installListeners() {
            BasicButtonListener listener = new BasicButtonListener(this);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.addFocusListener(listener);
            this.addPropertyChangeListener(listener);
            this.addChangeListener(listener);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SheetBaseMath.collapseGroupLevelTo(OutlineGroupColTagBar.this.getSpread().getBook().getActiveSheet(), false, NumberButton.this.number - 1);
                }
            });
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.black);
            Graphics2D g2d = (Graphics2D)g;
            String text = this.getText() == null || this.getText().equals("") ? new Integer(0).toString() : this.getText();
            Font font = this.getFont();
            FontRenderContext frc = g2d.getFontRenderContext();
            LineMetrics lm = g2d.getFont().getLineMetrics(text, frc);
            GlyphVector gv = font.createGlyphVector(frc, text);
            int advance = (int)gv.getGlyphMetrics(0).getAdvance();
            g2d.drawString(text, (float)(this.getWidth() / 2 - advance / 2), (float)(this.getHeight() / 2) + lm.getDescent() + lm.getLeading());
        }

        @Override
        protected void paintBorder(Graphics g) {
            if (this.model.isArmed()) {
                this.loweredBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.raisedBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ColTagBarLayoutManager
    implements LayoutManager {
        private int cellWidth = 15;

        private ColTagBarLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int i;
            SortedAttributeSpanArray sasa = ((SpreadView)parent).getSpread().getBook().getActiveSheet().getColSpans();
            int depth = 0;
            for (int i2 = 0; i2 < sasa.size(); ++i2) {
                int level = ((SortedAttributeSpanArray.AttributeSpan)sasa.get(i2)).getOutlineGroupLevel();
                depth = level > depth ? level : depth;
            }
            int basePos = (parent.getWidth() - this.cellWidth) / 2;
            if (depth == 0) {
                for (i = 0; i <= 16; ++i) {
                    OutlineGroupColTagBar.this.nbs[i].setBounds(-1, -1, 0, 0);
                }
                return;
            }
            OutlineGroupColTagBar.this.nbs[0].setBounds(basePos, 4, this.cellWidth, this.cellWidth);
            OutlineGroupColTagBar.this.nbs[1].setBounds(basePos, this.cellWidth + 4, this.cellWidth, this.cellWidth);
            for (i = 2; i <= depth; ++i) {
                OutlineGroupColTagBar.this.nbs[i].setBounds(basePos, this.cellWidth * i + 4, this.cellWidth, this.cellWidth);
            }
            for (i = depth + 1; i < 16; ++i) {
                OutlineGroupColTagBar.this.nbs[i].setBounds(-1, -1, 0, 0);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

