/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUID;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExtDynamicDataSet
extends ExtDataSet
implements Cloneable {
    private HashMap _params;

    public static ExtDynamicDataSet getExtDynamicDataSet(Book book, String baseName, String define, ExtDataSetType dt, HashMap params) {
        ExtDataSetManager dsm = book.getDataSetManager();
        ExtDynamicDataSet dds = null;
        if (dsm.isContainedValue()) {
            ExtDynamicDataSet[] ads = dsm.getDatasetsBySourceName(baseName);
            for (int i = 0; i < ads.length; ++i) {
                ExtDynamicDataSet ds = ads[i];
                if (!(params == null ? ds._params == null : params.equals(ds._params))) continue;
                dds = ds;
                break;
            }
        }
        return dds != null ? dds : new ExtDynamicDataSet(book, baseName, define, dt, params);
    }

    public static ExtDynamicDataSet getExtDynamicDataSet(ExtDataSet src, HashMap params) {
        ExtDataSetType datasetType = src.getDataSetType();
        String define = datasetType.trimPrefix(src._define);
        define = define == null ? src._define : define;
        return ExtDynamicDataSet.getExtDynamicDataSet(src._book, src._name, define, src.getDataSetType(), params);
    }

    private ExtDynamicDataSet(Book book, String baseName, String define, ExtDataSetType dt, HashMap params) {
        super(book, baseName + System.currentTimeMillis() + "_" + ExprUID.getUID(), define, dt);
        this._params = params;
    }

    public void setColumns(SortedObjectArray cols) {
        this._columns.clear();
        int iEnd = cols.size();
        for (int i = 0; i < iEnd; ++i) {
            ExtColumn col = (ExtColumn)((ExtColumn)cols.get(i)).clone();
            col.setDataSet(this);
            this._columns.append(col);
        }
    }

    public HashMap getParameters() {
        return this._params;
    }

    private ParameterImpl _getParamNoCase(Map map, String key) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            ParameterImpl param = (ParameterImpl)i.next().getValue();
            if (param.getName().compareToIgnoreCase(key) != 0) continue;
            return param;
        }
        return null;
    }

    @Override
    public void updateDataSet() {
        ExtDataSetManager dsm = this._book.getDataSetManager();
        ExecutionContext ctx = dsm.getExecutionContext();
        if (this._params != null) {
            Map dstParams = ctx.getDataSetParameters();
            if (dstParams == null) {
                ctx.setDataSetParameters(this._params);
            } else {
                Iterator i = this._params.entrySet().iterator();
                while (i.hasNext()) {
                    ParameterImpl param = (ParameterImpl)i.next().getValue();
                    ParameterImpl oldParam = this._getParamNoCase(dstParams, param.getName());
                    if (oldParam == null) {
                        dstParams.put(param.getName(), param);
                        continue;
                    }
                    oldParam.setValue(param.getValue());
                }
            }
        }
        if (dsm.getExtDataSetFactory().updateDataSet(this, ctx)) {
            this.setCurrentGroup(this.getDefaultGroup());
        }
    }
}

