/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.io.htm.serial.String2Variant;
import com.kingdee.bos.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ParameterImpl
extends CommonCalculableProps
implements IParameter,
Cloneable {
    private int _dataType = 0;
    private String _name;
    private String _alias;
    private String _desc;
    private String _formula;
    private boolean _nullable;
    private boolean _userDefine;
    private boolean _ignoreNull = true;
    private Variant _value;
    private Object[] _availableValues;
    private Class _editor;
    private Character p = Character.valueOf('@');
    public static final String DT = "DT";
    public static final String NM = "NM";
    public static final String AA = "AA";
    public static final String VA = "VA";
    public static final String AVV = "AVV";

    public ParameterImpl() {
        super(ExtConst.FORMULA_HYPERLINK, null);
    }

    public ParameterImpl(String name, String alias, int dataType, Variant value, boolean nullable) {
        this();
        this._name = name;
        this._alias = alias;
        this._dataType = dataType;
        this._value = value;
        this._nullable = nullable;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public void setAlias(String alias) {
        this._alias = alias;
    }

    @Override
    public int getDataType() {
        return this._dataType;
    }

    @Override
    public void setDataType(int type) {
        this._dataType = type;
    }

    @Override
    public Variant getValue() {
        return this._value;
    }

    @Override
    public void setValue(Variant value) {
        this._value = value;
    }

    @Override
    public boolean isNullable() {
        return this._nullable;
    }

    @Override
    public void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public void setDescription(String desc) {
        this._desc = desc;
    }

    @Override
    public Object[] getAvailableValues() {
        return this._availableValues;
    }

    @Override
    public void setAvailableValues(Object[] values) {
        this._availableValues = values;
    }

    @Override
    public Class getEditorClass() {
        return this._editor;
    }

    @Override
    public void setEditorClass(Class cls) {
        this._editor = cls;
    }

    @Override
    public boolean isUserDefine() {
        return this._userDefine;
    }

    @Override
    public void setUserDefine(boolean userDefine) {
        this._userDefine = userDefine;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Name: ");
        sb.append(this._name);
        sb.append("] [Alias: ");
        sb.append(this._alias);
        sb.append("] [Value: ");
        sb.append(this._value);
        sb.append("] [Nullable: ");
        sb.append(this._nullable);
        sb.append("] ");
        return sb.toString();
    }

    @Override
    public Variant calc(ExprContext ctx, ICalculable owner) {
        return this._expr == null ? this._value : this._expr.execute(ctx, owner).getVariant();
    }

    public void setFormula(String formula) {
        this._formula = formula;
    }

    public String getFormula() {
        return this._formula;
    }

    public Map toJsonFormMap() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(DT, String.valueOf(this._dataType));
        if (!StringUtil.isEmptyString((String)this._name)) {
            jsonMap.put(NM, this._name);
        }
        if (!StringUtil.isEmptyString((String)this._alias)) {
            jsonMap.put(AA, this._alias);
        }
        if (this._value != Variant.nullVariant) {
            jsonMap.put(VA, Variant2String.toString(this._value));
        }
        if (this._availableValues != null) {
            jsonMap.put(AVV, Arrays.asList(this._availableValues));
        }
        return jsonMap;
    }

    public void fromJsonMap(Map map) {
        this._dataType = Integer.parseInt((String)map.get(DT));
        this._name = (String)map.get(NM);
        this._alias = (String)map.get(AA);
        Object value = map.get(VA);
        this._value = value != null ? String2Variant.toVariant((String)value, this._dataType) : Variant.nullVariant;
        value = map.get(AVV);
        if (value != null) {
            this._availableValues = (Object[])value;
        }
    }

    public int hashCode() {
        return (this.getParameterPrefix() + this.getName()).hashCode();
    }

    @Override
    public Character getParameterPrefix() {
        return this.p;
    }

    public void setParameterPrefix(Character p) {
        this.p = p;
    }

    @Override
    public boolean isIgnoreNull() {
        return this._ignoreNull;
    }

    @Override
    public void setIgnoreNull(boolean ignoreNull) {
        this._ignoreNull = ignoreNull;
    }

    public Expr getExpr() {
        return this._expr;
    }
}

