/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ReportFields;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ReportFieldUtil {
    public static String getDataSetId(String define) {
        if (StringUtil.isEmptyString((String)define)) {
            return "";
        }
        String[] arr = define.split("\\\\");
        return arr[arr.length - 1];
    }

    public static String toXml(List<ReportFields> fieldsList) {
        Element dataSets = new Element("ExtReport");
        for (ReportFields fields : fieldsList) {
            Element dataSet = new Element("DataSet");
            dataSet.setAttribute("id", fields.getDataSetId());
            for (String fieldName : fields.getFieldNames()) {
                Element eField = new Element("Field");
                eField.setAttribute("name", fieldName);
                dataSet.addContent((Content)eField);
            }
            dataSets.addContent((Content)dataSet);
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setIndent(null);
        XMLOutputter outter = new XMLOutputter(format);
        String xmlstr = outter.outputString(dataSets);
        return xmlstr;
    }

    public static List<ReportFields> fromXml(String fieldsDefined) throws JDOMException, IOException {
        ArrayList<ReportFields> reportFiedls = new ArrayList<ReportFields>();
        StringReader in = new StringReader(fieldsDefined);
        Document doc = new SAXBuilder().build((Reader)in);
        ((Reader)in).close();
        Element root = doc.getRootElement();
        List elements = root.getChildren();
        for (Element element2 : elements) {
            ReportFields fields = new ReportFields();
            fields.setDataSetId(element2.getAttributeValue("id"));
            List elements1 = element2.getChildren();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Element element2 : elements1) {
                fieldNames.add(element2.getAttributeValue("name"));
            }
            fields.setFieldNames(fieldNames);
            reportFiedls.add(fields);
        }
        return reportFiedls;
    }
}

