/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.frame;

import com.kingdee.bos.ctrl.kds.frame.CompositeScrollBarPane;
import com.kingdee.bos.ctrl.kds.frame.MultiViewPane;
import com.kingdee.bos.ctrl.kds.frame.MvpScrollBar;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class MvpScrollBarManager {
    private CompositeScrollBarPane[] _vPanels;
    private CompositeScrollBarPane[] _hPanels;
    private boolean _vPanelsVisible = true;
    private boolean _hPanelsVisible = true;
    private MultiViewPane _mvp;
    private AdjustmentListener _vsbAdjustmentListener;
    private AdjustmentListener _hsbAdjustmentListener;

    MvpScrollBarManager(MultiViewPane mvp) {
        this._mvp = mvp;
        this._vsbAdjustmentListener = new VSBAdjustmentListener();
        this._hsbAdjustmentListener = new HSBAdjustmentListener();
        this._vPanels = new CompositeScrollBarPane[this._mvp.getMaxVertCount()];
        this._hPanels = new CompositeScrollBarPane[this._mvp.getMaxHoriCount()];
    }

    public void reset() {
        for (int i = this._mvp.getMaxVertCount() - 1; i >= 0; --i) {
            this.removeVScrollPanel(i);
        }
        for (int j = this._mvp.getMaxHoriCount() - 1; j >= 0; --j) {
            this.removeHScrollPanel(j);
        }
    }

    public void update() {
        int i;
        for (i = this._mvp.getVerticalCount(); i < this._mvp.getMaxVertCount(); ++i) {
            this.removeVScrollPanel(i);
        }
        for (i = this._mvp.getHorizonCount(); i < this._mvp.getMaxHoriCount(); ++i) {
            this.removeHScrollPanel(i);
        }
    }

    public CompositeScrollBarPane getHScrollPanel(int index) {
        return this._hPanels[index];
    }

    public CompositeScrollBarPane getVScrollPanel(int index) {
        return this._vPanels[index];
    }

    public void addHScrollPanel(int index, CompositeScrollBarPane scrollPanel) {
        this.removeHScrollPanel(index);
        this._hPanels[index] = scrollPanel;
        this.setComponentIndex(scrollPanel, index);
        if (scrollPanel != null) {
            scrollPanel.setVisible(this._hPanelsVisible);
            this._mvp.add((Component)((Object)scrollPanel));
            this.setComponentIndex(scrollPanel, index);
            MvpScrollBar sb = scrollPanel.getScrollBar();
            ((JScrollBar)((Object)sb)).addAdjustmentListener(this._hsbAdjustmentListener);
        }
    }

    public void addVScrollPanel(int index, CompositeScrollBarPane scrollPanel) {
        this.removeVScrollPanel(index);
        this._vPanels[index] = scrollPanel;
        this.setComponentIndex(scrollPanel, index);
        if (scrollPanel != null) {
            scrollPanel.setVisible(this._vPanelsVisible);
            this._mvp.add((Component)((Object)scrollPanel));
            this.setComponentIndex(scrollPanel, index);
            MvpScrollBar sb = scrollPanel.getScrollBar();
            ((JScrollBar)((Object)sb)).addAdjustmentListener(this._vsbAdjustmentListener);
        }
    }

    public void removeHScrollPanel(int index) {
        CompositeScrollBarPane scrollPanel = this._hPanels[index];
        this._hPanels[index] = null;
        if (scrollPanel != null) {
            this._mvp.remove((Component)((Object)scrollPanel));
            MvpScrollBar sb = scrollPanel.getScrollBar();
            ((JScrollBar)((Object)sb)).removeAdjustmentListener(this._hsbAdjustmentListener);
            ((JScrollBar)((Object)sb)).setMinimum(0);
        }
    }

    public void removeVScrollPanel(int index) {
        CompositeScrollBarPane scrollPanel = this._vPanels[index];
        this._vPanels[index] = null;
        if (scrollPanel != null) {
            this._mvp.remove((Component)((Object)scrollPanel));
            MvpScrollBar sb = scrollPanel.getScrollBar();
            ((JScrollBar)((Object)sb)).removeAdjustmentListener(this._vsbAdjustmentListener);
            ((JScrollBar)((Object)sb)).setMinimum(0);
        }
    }

    public JScrollBar getVScrollBar(int index) {
        CompositeScrollBarPane scrollPanel = this.getVScrollPanel(index);
        if (scrollPanel != null) {
            return scrollPanel.getScrollBar();
        }
        return null;
    }

    public JScrollBar getHScrollBar(int index) {
        CompositeScrollBarPane scrollPanel = this.getHScrollPanel(index);
        if (scrollPanel != null) {
            return scrollPanel.getScrollBar();
        }
        return null;
    }

    public int getHScrollPanelHeight() {
        if (!this._hPanelsVisible) {
            return 0;
        }
        return 17;
    }

    public int getHScrollPanelHeightWhenHasScrollBar() {
        if (this._hPanelsVisible) {
            return this.getHScrollPanelHeight();
        }
        return 0;
    }

    public int getVScrollPanelWidth() {
        if (this._vPanelsVisible) {
            return 17;
        }
        return 0;
    }

    private void setComponentIndex(CompositeScrollBarPane panel, int index) {
        if (panel != null) {
            MultiViewPane.setComponentIndex((JComponent)((Object)panel), index, "ViewIndex");
            MultiViewPane.setComponentIndex((JComponent)((Object)panel.getScrollBar()), index, "ViewIndex");
        }
    }

    public void setHScrollPanelVisible(boolean isVisible) {
        int hCount = this._mvp.getHorizonCount();
        this._hPanelsVisible = isVisible;
        for (int i = 0; i < hCount; ++i) {
            CompositeScrollBarPane j = this._hPanels[i];
            if (j == null) continue;
            ((JComponent)((Object)j)).setVisible(isVisible);
        }
        if (isVisible && this._mvp.isSplited(0)) {
            return;
        }
        this._mvp.getLayoutInfoManager().setHSplitButtonVisible(isVisible);
    }

    public void setVScrollPanelVisible(boolean isVisible) {
        int vCount = this._mvp.getVerticalCount();
        this._vPanelsVisible = isVisible;
        for (int i = 0; i < vCount; ++i) {
            CompositeScrollBarPane j = this._vPanels[i];
            if (j == null) continue;
            ((JComponent)((Object)j)).setVisible(isVisible);
        }
        this._mvp.getLayoutInfoManager().setVSplitButtonVisible(isVisible);
    }

    private class HSBAdjustmentListener
    implements AdjustmentListener {
        private HSBAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            JScrollBar sb = (JScrollBar)e.getSource();
            int hIndex = MultiViewPane.getComponentIndex(sb, "ViewIndex");
            int value = e.getValue();
            MvpScrollBarManager.this._mvp.setViewPosition(0, hIndex, value);
        }
    }

    private class VSBAdjustmentListener
    implements AdjustmentListener {
        private VSBAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            JScrollBar sb = (JScrollBar)e.getSource();
            int vIndex = MultiViewPane.getComponentIndex(sb, "ViewIndex");
            int value = e.getValue();
            MvpScrollBarManager.this._mvp.setViewPosition(1, vIndex, value);
        }
    }
}

