/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.action;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.model.struct.Column;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.util.profile.IObjectProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.ObjectProfiler;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboFileChooser;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import javax.swing.SwingUtilities;

class PerformanceAction
extends SpreadAction {
    public PerformanceAction(SpreadContext context) {
        super(context);
    }

    @Override
    public void doAction(ActionEvent e) {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        if (w instanceof Dialog) {
            new PerformanceDialog((Dialog)w, this._context).setVisible(true);
        } else if (w instanceof Frame) {
            new PerformanceDialog((Frame)w, this._context).setVisible(true);
        } else {
            new PerformanceDialog((Frame)null, this._context).setVisible(true);
        }
    }

    static class PerformanceDialog
    extends KDDialog {
        private SpreadContext context;
        private KDTextArea taTip;
        private KDTextField tfText;
        private KDLabel lbResult;
        private KDButton okBtn;
        private KDButton cancelBtn;
        private KDComboFileChooser fc;
        private static String tip = "\u8f93\u5165\u5b57\u7b26[\u542b\u4e49]\nbook[book]\nsheet[activesheet]\nsheet 0 0[0\u884c0\u5217\u7684cell]\nsheet 0 -1[Row 0]\nsheet -1 0[Col 0]\ncontext[context]\nspread[spread]\nframe[frame]\nstyles ssas[ssas]\nstyles styles[styles]\nstyles fonts[fonts]\nstyles strocks[strocks]\nprint";
        private static String result = "\u8fd9\u91cc\u663e\u793a\u5bf9\u8c61\u5927\u5c0f[byte]:";

        public PerformanceDialog(Frame parent, SpreadContext context) {
            super(parent, true);
            this.context = context;
            this.initComponents();
            this.initListeners();
            this.pack();
            this.setLocationRelativeTo(null);
        }

        public PerformanceDialog(Dialog parent, SpreadContext context) {
            super(parent, true);
            this.context = context;
            this.setSize(190, 80);
            this.setResizable(false);
            this.initComponents();
            this.initListeners();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit() {
            Object obj;
            block20: {
                String[] args;
                block21: {
                    block24: {
                        block23: {
                            block22: {
                                String cmd = this.tfText.getText();
                                if (StringUtil.isEmptyString((String)cmd)) {
                                    return;
                                }
                                obj = null;
                                args = cmd.split(" ");
                                if (args.length != 1) break block21;
                                if (!args[0].equalsIgnoreCase("book")) break block22;
                                obj = this.context.getBook();
                                break block20;
                            }
                            if (!args[0].equalsIgnoreCase("sheet")) break block23;
                            obj = this.context.getBook().getActiveSheet();
                            break block20;
                        }
                        if (!args[0].equalsIgnoreCase("context")) break block24;
                        obj = this.context.getBook().getActiveSheet();
                        break block20;
                    }
                    if (args[0].equalsIgnoreCase("spread")) {
                        obj = this.context.getSpread();
                        break block20;
                    } else if (args[0].equalsIgnoreCase("frame")) {
                        obj = SwingUtilities.getWindowAncestor((Component)((Object)this.context));
                        break block20;
                    } else {
                        if (!args[0].equalsIgnoreCase("print")) {
                            this.lbResult.setText(result + "\u547d\u4ee4\u6709\u8bef");
                            return;
                        }
                        obj = this.context.getPrintManager();
                    }
                    break block20;
                }
                if (args.length == 2) {
                    if (!args[0].equalsIgnoreCase("styles")) {
                        this.lbResult.setText(result + "\u547d\u4ee4\u6709\u8bef");
                        return;
                    }
                    String key = args[1];
                    obj = Styles.getStaticContent().get(key);
                } else if (args.length == 3) {
                    if (!args[0].equalsIgnoreCase("sheet")) {
                        this.lbResult.setText(result + "\u547d\u4ee4\u6709\u8bef");
                        return;
                    }
                    int r = 0;
                    int c = 0;
                    try {
                        r = Integer.valueOf(args[1]);
                        c = Integer.valueOf(args[2]);
                    }
                    catch (NumberFormatException e) {
                        this.lbResult.setText(result + "\u547d\u4ee4\u6709\u8bef");
                        return;
                    }
                    if (r == -1 && c == -1) {
                        obj = this.context.getBook().getActiveSheet();
                    } else if (r == -1) {
                        Column col = this.context.getBook().getActiveSheet().getColumn(r, false);
                        obj = col;
                    } else if (c == -1) {
                        Row row = this.context.getBook().getActiveSheet().getRow(r, false);
                        obj = row;
                    } else {
                        Row row = this.context.getBook().getActiveSheet().getRow(r, false);
                        if (row != null) {
                            obj = row.getCell(c, false);
                        }
                    }
                }
            }
            String fileName = (String)this.fc.getData();
            String s = PerformanceDialog.profiledump(obj, fileName, null);
            this.lbResult.setText(result + s);
        }

        public boolean prepare() {
            return true;
        }

        private void initComponents() {
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)this.createTextPanel(), "Center");
            cp.add((Component)this.createCtrlPanel(), "South");
        }

        private KDPanel createTextPanel() {
            this.taTip = new KDTextArea(tip);
            this.tfText = new KDTextField();
            this.lbResult = new KDLabel(result);
            this.fc = new KDComboFileChooser();
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)new BorderLayout());
            panel.add((Component)this.taTip, (Object)"North");
            KDPanel panel2 = new KDPanel();
            panel2.setLayout((LayoutManager)new BorderLayout());
            panel2.add((Component)this.tfText, (Object)"North");
            panel2.add((Component)this.fc, (Object)"Center");
            panel2.add((Component)this.lbResult, (Object)"South");
            panel.add((Component)panel2, (Object)"Center");
            return panel;
        }

        private KDPanel createCtrlPanel() {
            this.okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
            this.cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)new FlowLayout());
            panel.add((Component)this.okBtn);
            panel.add((Component)this.cancelBtn);
            return panel;
        }

        private void initListeners() {
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.closeDialog();
                }
            });
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.commit();
                }
            });
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String profiledump(Object obj, String fileName, IdentityHashMap map) {
            if (obj == null) {
                return "null object";
            }
            IObjectProfileNode profile = null;
            profile = map != null ? ObjectProfiler.profile(obj, map) : ObjectProfiler.profile(obj);
            long size = profile.size();
            if (!StringUtil.isEmptyString((String)fileName)) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(fileName);
                    String s = profile.dump();
                    fos.write(s.getBytes());
                    fos.flush();
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{fos});
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{fos});
                }
                CloseUtil.close((Closeable[])new Closeable[]{fos});
            }
            return "" + size;
        }
    }
}

