/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state;

import com.kingdee.bos.ctrl.kds.impl.CellEditManager;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.impl.state.DefaultState;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;

public class EditingState
extends DefaultState {
    private CellEditManager _cm;
    private Object _condition;
    private Sheet _sheet;

    EditingState(SpreadContext context, Object condition) {
        super(context);
        this._cm = this._context.getEditManager();
        this.init(condition);
    }

    void init(Object condition) {
        this._condition = condition;
        this._sheet = this._context.getBook().getActiveSheet();
    }

    @Override
    public boolean start(int preKey) {
        return this._cm.startEditing(this._condition);
    }

    @Override
    public boolean stop(int forceKey) {
        boolean b = this._cm.stopEditing();
        Book book = this._context.getBook();
        if (b && this._sheet != book.getActiveSheet()) {
            for (int i = book.getSheetCount() - 1; i >= 0; --i) {
                book.getISheet(i).setSelected(false);
            }
            book.setActiveSheet(this._sheet);
        }
        return b;
    }

    @Override
    public boolean cancel(int forceKey) {
        return this._cm.cancelEditing();
    }

    public ICellEditor getCurrentEditor() {
        return this._cm.getCurrentEditor();
    }

    @Override
    public int getKey() {
        return SpreadStateManager.Key_Edit;
    }

    @Override
    public void changed(BookChangeEvent e) {
        SpreadStateManager stateMgr;
        if (e.isSheetDeactive() && !(stateMgr = this._context.getStateManager()).isState2(SpreadStateManager.Key_Range_Select)) {
            stateMgr.stop();
        }
    }
}

