/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadCellTextRender;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;
import java.math.BigDecimal;

public interface KDSpreadHelper {
    public static void autoFitRowHeight(KDSpread spread) {
        Book book = spread.getBook();
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            return;
        }
        Sheet sheet = spread.getBook().getActiveSheet();
        int viewMode = sheet.getSheetOption().getCellDisplayMode();
        ICellDisplayProvider prov = spread.getCellDisplayProvider();
        Object value = prov.getBaseValue(cell, viewMode);
        Range rowRange = sheet.getRowRange(cell.getRow(), cell.getRow());
        int cellHeight = sheet.getDefRowHeight();
        Integer oldHeight = rowRange.getRowHeight();
        if (null != oldHeight) {
            cellHeight = oldHeight;
        }
        if (value instanceof String && cell.getStyle().isWrapText()) {
            Graphics2D g2d = (Graphics2D)spread.getGraphics();
            IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
            if (cellRender instanceof SpreadCellTextRender) {
                float h;
                int pos = sheet.getColSpans().searchSpan(cell.getCol());
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (pos >= 0) {
                    span = (SortedAttributeSpanArray.AttributeSpan)sheet.getColSpans().getSpan(pos);
                }
                float colWidth = span != null ? (float)span.getLength() : (float)sheet.getDefColWidth();
                float rowHeight = cellHeight;
                CellBlock mergeBlock = book.getActiveSheet().getMergeBlock(cell);
                if (mergeBlock != null) {
                    Rectangle bufRect = new Rectangle();
                    SheetBaseMath.getBlockRect(cell.getSheet(), mergeBlock, false, bufRect);
                    Rectangle bd = bufRect.getBounds();
                    colWidth = bd.width;
                    rowHeight = bd.height;
                }
                if ((h = ((SpreadCellTextRender)cellRender).getPreferredHeight(g2d, new Rectangle(0, 0, (int)colWidth, (int)rowHeight), value, cell.getStyle())) > 0.0f && h > rowHeight) {
                    double c = (double)h - (double)rowHeight;
                    rowRange.setRowHeight(cellHeight + ((int)c + 4));
                }
            }
            if (cell.getStyle().isVerticalText()) {
                KDSpreadHelper.autoFitVerticalTextHeight(spread, cell, value.toString(), rowRange, oldHeight);
            }
        } else if (value instanceof String && cell.getStyle().isVerticalText()) {
            KDSpreadHelper.autoFitVerticalTextHeight(spread, cell, value.toString(), rowRange, oldHeight);
        }
    }

    public static void paintWrapTextCell(KDSpread spread) {
        Book book = spread.getBook();
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            return;
        }
        if (null == cell.getMerge(false) && !cell.getStyle().isWrapText() && cell.getValue().isString() && StringUtil.isWrapString((String)((String)cell.getValue().getValue()))) {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getStyle());
            sa.setWrapText(true);
            cell.setSSA((ShareStyleAttributes)sa);
        }
    }

    public static void autoFitVerticalTextHeight(KDSpread spread, Cell cell, String value, Range rowRange, Integer oldHeight) {
        Graphics2D g = (Graphics2D)spread.getGraphics();
        KDFont f = cell.getStyle().getKDFont();
        g.setColor(cell.getStyle().getFontColor());
        g.setFont((Font)f);
        LineMetrics lm = f.getLineMetrics(value, g.getFontRenderContext());
        double fontHeight = lm.getAscent() + lm.getDescent();
        float height = 0.0f;
        int sourceHeight = (int)(fontHeight * (double)value.length());
        if ((float)sourceHeight > height) {
            height = sourceHeight;
        }
        if (height > 0.0f && height > (float)oldHeight.intValue()) {
            rowRange.setRowHeight((int)height + 4);
        }
    }

    public static String calSumAndAvg(SpreadView view) {
        CellBlock cellBlock;
        Book book = view.getSpread().getBook();
        Range range = book.getSelectionRange();
        Object[] array = range.getArray();
        if (array != null && array.length > 0 && (cellBlock = (CellBlock)array[0]).isSingleCell() && array.length > 1 && (CellBlock)array[1] == null) {
            return "";
        }
        Sheet.ICellsIterator rangeCellsIterator = book.getRangeCellsIterator(range, false, true);
        BigDecimal totalBig = new BigDecimal("0");
        BigDecimal avgBig = new BigDecimal("0");
        int cellCount = 0;
        int rumericalTotal = 0;
        int isNotBig = 0;
        while (rangeCellsIterator.hasNext()) {
            Cell cell = rangeCellsIterator.next();
            if (cell.isHidden()) continue;
            Variant var = cell.getValue();
            Object value = var.getValue();
            if (var == null || value == null || var.getVt() == 12 || var.getVt() == 13) {
                ++isNotBig;
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof BigDecimal) {
                    ++rumericalTotal;
                    totalBig = totalBig.add((BigDecimal)value);
                }
                if (value instanceof Double) {
                    ++rumericalTotal;
                    totalBig = totalBig.add(new BigDecimal((Double)value));
                }
                if (value instanceof Integer) {
                    ++rumericalTotal;
                    totalBig = totalBig.add(new BigDecimal((Integer)value));
                }
            }
            if (value instanceof String && StringUtil.isNumber((String)((String)value))) {
                try {
                    Variant numberVar = Variant.stringToNumberVar((String)value);
                    if (numberVar.getValue() instanceof Number) {
                        ++rumericalTotal;
                        totalBig = totalBig.add((BigDecimal)numberVar.getValue());
                    }
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            }
            ++cellCount;
            ++isNotBig;
        }
        if (rumericalTotal > 0) {
            avgBig = totalBig.divide(BigDecimal.valueOf(rumericalTotal), 2, 4);
        }
        if (cellCount > 1 && rumericalTotal > 1) {
            return "\u5e73\u5747\u503c: " + avgBig + "   \u8ba1\u6570: " + isNotBig + "   \u6c42\u548c: " + totalBig;
        }
        return "";
    }
}

