/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.clipboard;

import com.kingdee.bos.ctrl.common.ClipboardProxy;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.io.BookIOController;
import com.kingdee.bos.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.kds.io.clipboard.KDSTransferable;
import com.kingdee.bos.ctrl.kds.io.clipboard.StringWalker;
import com.kingdee.bos.ctrl.kds.io.kml.BookToKml;
import com.kingdee.bos.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedSheetArray;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.xml.sax.InputSource;
import sun.awt.AppContext;

public class ClipboardTransferHandler
implements Serializable {
    private static final long serialVersionUID = -3247920951269236765L;
    static final String XML_SPREADSHEET = "XML Spreadsheet";
    static final String KML = "KML";
    static final String SPREAD_GRAPHS = "Spread_Graphs";
    static final String RANGE_UUID = "KDRANGE UUID";
    private static boolean canAccessSystemClipboard = true;
    private static Object SandboxClipboardKey = new Object();

    private static boolean canAccessSystemClipboard() {
        if (canAccessSystemClipboard) {
            if (GraphicsEnvironment.isHeadless()) {
                canAccessSystemClipboard = false;
                return false;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkSystemClipboardAccess();
                    return true;
                }
                catch (SecurityException se) {
                    canAccessSystemClipboard = false;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean exportGraphsToClipboard(byte[] str) {
        boolean bRet = false;
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip != null) {
            clip.setContents(new StringSelection(null), null);
            ClipboardProxy clipProxy = ClipboardProxy.getInstance();
            if (clipProxy != null) {
                clipProxy.openClipboard(null);
                clipProxy.setClipboardDataByName(SPREAD_GRAPHS, str);
                clipProxy.closeClipboard();
                bRet = true;
            }
        }
        return bRet;
    }

    public static byte[] importGraphsDataFromClipboard() {
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip == null) {
            return null;
        }
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy == null) {
            return null;
        }
        clipProxy.openClipboard(null);
        try {
            byte[] byArray = clipProxy.getClipboardDataByName(SPREAD_GRAPHS);
            return byArray;
        }
        finally {
            clipProxy.closeClipboard();
        }
    }

    public static boolean exportToClipboard(Book srcBook, SortedCellBlockArray blocks, byte[] uuid) {
        boolean bRet = false;
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        boolean securityFilter = SheetBaseMath.isSecuritySheet(srcBook.getActiveSheet());
        if (clip != null) {
            KDSTransferable tf = new KDSTransferable(srcBook.getActiveSheet(), securityFilter);
            clip.setContents(tf, null);
            SortedSheetArray srcSheets = srcBook.getSelectSheets();
            KDClipboard.clear();
            KDClipboard.setSourceSelection(srcSheets, blocks);
            Sheet desSheet = null;
            int size = srcSheets.size();
            for (int i = 0; i < size; ++i) {
                boolean bfilter;
                Sheet srcSheet = srcSheets.getSheet(i);
                desSheet = KDClipboard.getNewSheet(srcSheet.getSheetName());
                srcSheet.copyPartSheetPacked(blocks, desSheet, 0, 0, KDClipboard.isOffset(), true);
                CellBlock cellBlock = (CellBlock)blocks.get(0);
                AlgorithmUtil.changeValueToDisplayValue(srcSheet, desSheet, cellBlock.getRow(), cellBlock.getCol());
                boolean bl = bfilter = srcSheet.getAutoFilterArea() != null || srcSheet.getAdvancedFilterArea() != null;
                if (securityFilter && !bfilter) {
                    int offsetRow = 0;
                    int offsetColumn = 0;
                    CellBlock cellBlock2 = (CellBlock)blocks.get(0);
                    if (cellBlock2 != null) {
                        offsetRow = cellBlock2.getRow();
                        offsetColumn = cellBlock2.getCol();
                    }
                    if (srcSheet != null) {
                        AlgorithmUtil.delHideRowsAndColsWithOffset(srcSheet, desSheet, offsetRow, offsetColumn, srcSheet.getSecHidedRows(), srcSheet.getSecHidedCols());
                        Selection sel = desSheet.getSheetOption().getSelection();
                        sel.changeSelection(CellBlock.getCellBlock(0, 0, desSheet.getMaxRowIndex(true), desSheet.getMaxColIndex(true)), sel.getSelectMode());
                    }
                }
                if (!bfilter) continue;
                CellBlock cellBlock3 = (CellBlock)blocks.get(0);
                AlgorithmUtil.delAllHideRowsAndCols(desSheet, srcSheet, cellBlock3.getRow(), cellBlock3.getCol());
                Selection sel = desSheet.getSheetOption().getSelection();
                sel.changeSelection(CellBlock.getCellBlock(0, 0, desSheet.getMaxRowIndex(true), desSheet.getMaxColIndex(true)), sel.getSelectMode());
            }
            Book dstBook = desSheet.getBook();
            dstBook.calcQueue();
            ClipboardProxy clipProxy = ClipboardProxy.getInstance();
            if (clipProxy != null) {
                clipProxy.openClipboard(null);
                clipProxy.setClipboardDataByName(RANGE_UUID, uuid);
                if (KDClipboard.isEnableSpreadSheet()) {
                    ClipboardTransferHandler.setBookXmlToClipboard(clipProxy, XML_SPREADSHEET, srcBook, dstBook);
                    ClipboardTransferHandler.setBookXmlToClipboard(clipProxy, KML, srcBook, dstBook);
                }
                clipProxy.closeClipboard();
            }
            bRet = true;
        }
        return bRet;
    }

    private static void setBookXmlToClipboard(ClipboardProxy clipProxy, String name, Book srcBook, Book dstBook) {
        StringWriter writer = new StringWriter();
        BookToKml btk = new BookToKml();
        BookIOController bc = new BookIOController();
        if (srcBook.getDeps().isExtendMode()) {
            bc.setIOMode(bc.getIOMode() & ~IBookFieldFlags.FLAG_FORMULA);
        }
        bc.setKmlUOTrans(srcBook.getUserObjectsProvider());
        bc.setToClipboard(true);
        bc.setForExcel(name == XML_SPREADSHEET);
        btk.setBookIOController(bc);
        try {
            btk.export(dstBook, writer);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String str = writer.getBuffer().toString();
        byte[] bts = null;
        try {
            bts = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bts = null;
        }
        clipProxy.setClipboardDataByName(name, bts);
    }

    public static boolean isClipboardDataAvailable() {
        Transferable tf;
        if (KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID()) && KDClipboard.canPaste()) {
            return true;
        }
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip == null) {
            return false;
        }
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy != null) {
            clipProxy.openClipboard(null);
            byte[] bytes = clipProxy.getClipboardDataByName(XML_SPREADSHEET);
            clipProxy.closeClipboard();
            if (bytes != null && bytes.length > 0) {
                return true;
            }
        }
        if ((tf = clip.getContents(null)) == null) {
            return false;
        }
        DataFlavor[] flavors = tf.getTransferDataFlavors();
        DataFlavor flavor = ClipboardTransferHandler.getStringFlavor(flavors);
        if (flavor != null) {
            try {
                Object data = tf.getTransferData(flavor);
                return data != null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static Object importFromClipboard(Book dstBook) {
        return ClipboardTransferHandler.importFromClipboard(dstBook, 0);
    }

    public static Object importFromClipboard(Book dstBook, int cf) {
        Book book;
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if ((clipProxy == null || KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID())) && (book = KDClipboard.getClipboardBook()) != null) {
            return book;
        }
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip == null) {
            return null;
        }
        Object ret = null;
        if (cf == 0) {
            if (clipProxy != null) {
                clipProxy.openClipboard(null);
                ret = ClipboardTransferHandler.getBookFromClipBoardXml(KML, dstBook, clip, clipProxy);
                if (ret == null) {
                    ret = ClipboardTransferHandler.getBookFromClipBoardXml(XML_SPREADSHEET, dstBook, clip, clipProxy);
                }
                if (ret == null) {
                    clipProxy.closeClipboard();
                    ret = ClipboardTransferHandler.getClipBoardText(clip);
                }
            }
        } else if (cf == 1) {
            ret = ClipboardTransferHandler.getClipBoardText(clip);
        }
        return ret;
    }

    private static Object getClipBoardText(Clipboard clip) {
        DataFlavor[] flavors;
        DataFlavor flavor;
        Object ret = null;
        Transferable tf = clip.getContents(null);
        if (tf != null && (flavor = ClipboardTransferHandler.getStringFlavor(flavors = tf.getTransferDataFlavors())) != null) {
            Object data = null;
            try {
                data = tf.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (data instanceof String) {
                ret = data;
            }
        }
        return ret;
    }

    private static Object getBookFromClipBoardXml(String name, Book dstBook, Clipboard clip, ClipboardProxy clipProxy) {
        byte[] bytes = clipProxy.getClipboardDataByName(name);
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        Book ret = null;
        String str = null;
        try {
            str = new String(bytes, 0, bytes.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(bytes);
        }
        if (str != null) {
            KmlToBook kml = new KmlToBook();
            kml.setFromExcelClipboard(name == XML_SPREADSHEET);
            BookIOController ctrl = new BookIOController();
            ctrl.setKmlUOTrans(dstBook.getUserObjectsProvider());
            ctrl.setToClipboard(true);
            kml.setIOController(ctrl);
            int len = str.length();
            if (str.charAt(len - 1) != '>') {
                str = str.substring(0, len - 1);
            }
            try {
                Book book = Book.Manager.getNewBook("", 0);
                book.getDeps().setFunctionManager(dstBook.getDeps().getFunctionManager());
                kml.load(new InputSource(new StringReader(str)), book);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ret = kml.getBook();
            clipProxy.closeClipboard();
        }
        if (ret instanceof Book) {
            DataFlavor[] flavors;
            DataFlavor flavor;
            Book book = ret;
            book.setAutoCalculate(false);
            Transferable tf = clip.getContents(null);
            if (tf != null && (flavor = ClipboardTransferHandler.getStringFlavor(flavors = tf.getTransferDataFlavors())) != null) {
                Object data = null;
                try {
                    data = tf.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (data instanceof String) {
                    ClipboardTransferHandler.paste(book.getActiveSheet(), CellBlock.getCellBlock(0, 0), (String)data);
                }
            }
        }
        return ret;
    }

    public static byte[] getRangeUUID() {
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy != null) {
            clipProxy.openClipboard(null);
            byte[] bytes = clipProxy.getClipboardDataByName(RANGE_UUID);
            clipProxy.closeClipboard();
            return bytes;
        }
        return null;
    }

    static DataFlavor getStringFlavor(DataFlavor[] flavors) {
        int length = flavors.length;
        for (int i = 0; i < length; ++i) {
            if (DataFlavor.stringFlavor != flavors[i]) continue;
            return flavors[i];
        }
        return null;
    }

    static Clipboard getClipboard() {
        if (ClipboardTransferHandler.canAccessSystemClipboard()) {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
        if (clipboard == null) {
            clipboard = new Clipboard("Sandboxed Component Clipboard");
            AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
        }
        return clipboard;
    }

    private static void paste(Sheet sheet, CellBlock cb, String text) {
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        StringWalker.SeperateResult sr = StringWalker.separate2Array(text);
        int row = cb.getRow();
        int rowCount = sr.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Row rowObj = sheet.getRow(row++, false);
            int col = cb.getCol();
            int colCount = sr.getColCount();
            for (int j = 0; j < colCount; ++j) {
                Cell cell;
                String data = sr.getValueAt(i, j);
                if (rowObj == null || (cell = rowObj.getCell(col++, false)) == null || StringUtil.isEmptyString((String)data)) continue;
                if (!cell.hasFormula()) {
                    if (ClipboardTransferHandler.isFormula(data)) {
                        Variant var = cell.getValue();
                        cell.setFormula(data);
                        cell.setValue(var);
                        continue;
                    }
                    if (cell.getSSA().getNumberFormat() != null && cell.getSSA().getNumberFormat().length() > 0 && cell.getValue().getVt() != 10 || StringUtil.isScientificCounting((String)data)) continue;
                    data = StringUtil.getNumber((String)data);
                    ClipboardTransferHandler.trasToBigDecimal(cell, data);
                    continue;
                }
                if (ClipboardTransferHandler.isFormula(data)) continue;
                data = StringUtil.getNumber((String)data);
                ClipboardTransferHandler.trasToBigDecimal(cell, data);
            }
        }
    }

    public static void trasToBigDecimal(Cell cell, String data) {
        Variant var = cell.getValue();
        if (var.getVt() == 10) {
            try {
                var.setBigDecimal(new BigDecimal(data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isFormula(String formula) {
        return formula != null && formula.length() > 1 && formula.startsWith("=");
    }
}

