/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.htm.extweb;

import com.kingdee.bos.ctrl.kds.io.htm.KdsToHtmlExporter;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.ViewSplitInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReportHeader {
    private int _height;
    private int _width;
    private int _col;
    private int _row;
    private String _html;
    private Map _styles;
    private Sheet _sheet;
    private boolean _headerSet;
    private boolean _build;
    private String _visitFilePrefixPath;
    private String _fileSavePath;

    public ReportHeader(Sheet sheet, String visitFilePrefixPath, String fileSavePath) {
        this._sheet = sheet;
        ViewSplitInfo splitInfo = this._sheet.getSheetOption().getViewSplitInfo();
        this._headerSet = splitInfo.isFreezed();
        if (this._headerSet) {
            this._row = splitInfo.getRowSplit();
            this._col = splitInfo.getColSplit();
        }
        this._visitFilePrefixPath = visitFilePrefixPath;
        this._fileSavePath = fileSavePath;
    }

    public void buildHeader() throws IOException {
        if (!this._build) {
            if (this._headerSet && this._row > 0) {
                KdsToHtmlExporter export = new KdsToHtmlExporter(this._sheet, null);
                export.setFilePrefixPath(this._visitFilePrefixPath);
                export.setFileSavePath(this._fileSavePath);
                export.setRow1(0);
                export.setRow2(this._row - 1);
                this._html = export.buildHeader(this);
                this._styles = export.getStyle2Css().getStyle();
                this._height = export.getDivDim().getHeight();
                this._width = export.getDivDim().getWidth();
            } else {
                this._styles = new HashMap(1);
                this._html = "";
            }
            this._build = true;
        }
    }

    public String getLockCssClass(int row, int col) {
        if (this._headerSet) {
            if (row < this._row && col < this._col) {
                return "CLock";
            }
            if (row < this._row && col >= this._col) {
                return "VLock";
            }
            if (row >= this._row && col < this._col) {
                return "HLock";
            }
        }
        return "";
    }

    public static String getHorizontalCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("HLock").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" z-index: 10;").append("\r\n");
        cssBuf.append(" position: relative;").append("\r\n");
        cssBuf.append(" left: expression( this.parentElement.offsetParent.parentElement.scrollLeft );").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public static String getVerticalCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("VLock").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" z-index: 20;").append("\r\n");
        cssBuf.append(" position: relative;").append("\r\n");
        cssBuf.append(" top: expression(this.parentElement.offsetParent.parentElement.scrollTop);").append("\r\n");
        cssBuf.append('}');
        return cssBuf.toString();
    }

    public static String getCornerCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("CLock").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" z-index: 30;").append("\r\n");
        cssBuf.append(" position: relative;").append("\r\n");
        cssBuf.append(" top: expression(this.parentElement.offsetParent.parentElement.scrollTop);").append("\r\n");
        cssBuf.append(" left: expression( this.parentElement.offsetParent.parentElement.scrollLeft ); ").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public static String getHorizontalBoundaryLineCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("bdb").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" BORDER-BOTTOM: #000000 1px solid;").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public static String getVerticalBoundaryLineCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("bdr").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" BORDER-RIGHT: #000000 1px solid;").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public String getHorizontalBoundaryLine(int row) {
        if (this._headerSet && row == this._row - 1) {
            return "bdb";
        }
        return "";
    }

    public String getVerticalBoundaryLine(int col) {
        if (this._headerSet && this._col == col + 1) {
            return "bdr";
        }
        return "";
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public String getHtml() {
        return this._html;
    }

    public void setHtml(String html) {
        this._html = html;
    }

    public int getCol() {
        return this._col;
    }

    public int getRow() {
        return this._row;
    }

    public Map getStyles() {
        return this._styles;
    }

    public int getWidth() {
        return this._width;
    }

    public boolean isHorizontalHeaderSet() {
        return this._headerSet && this._row > 0;
    }

    public boolean isHeaderSet() {
        return this._headerSet;
    }
}

