/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

public final class FillType {
    public static final int Series = 2;
    public static final int GrowthTrend = 4;
    public static final int LinearTrend = 8;
    public static final int Days = 16;
    public static final int Weekdays = 32;
    public static final int Months = 64;
    public static final int Years = 128;
    public static final int Copy = 256;
    public static final int Formats = 512;
    public static final int Values = 1024;
    static final int PartNumber = 6;
    public static final FillType SERIES = new FillType(514);
    public static final FillType GROWTHTREND = new FillType(516);
    public static final FillType LINEARTREND = new FillType(520);
    public static final FillType COPY = new FillType(768);
    public static final FillType DAYS = new FillType(528);
    public static final FillType WEEKDAYS = new FillType(544);
    public static final FillType MONTHS = new FillType(576);
    public static final FillType YEARS = new FillType(640);
    public static final FillType DEFAULT = new FillType(774);
    public static final FillType FORMAT = new FillType(512);
    public static final FillType VALUES = new FillType(2);
    public static final FillType DEFAULT_EXCEPT_FORMAT = new FillType(262);
    static final FillType NUMBER = new FillType(14);
    static final FillType DATE = new FillType(242);
    static final FillType PARTNUMBER = new FillType(6);
    private int _flags;
    private int _statCount = 0;

    public FillType(int flags) {
        this._flags = flags;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public void addFlag(int flag) {
        this._flags |= flag;
    }

    public void setStatCount(int count) {
        this._statCount = count;
    }

    public boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public boolean includeFlag(int flag) {
        return (this._flags & flag) == flag;
    }

    public void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public void merge(FillType ft) {
        this._flags |= ft._flags;
    }

    public void addWeekdayFlag() {
        this._flags |= 0x32;
    }

    public void addDateFlag() {
        this._flags |= 0xF0;
    }

    public void addTrendFlag() {
        this._flags |= 0x40C;
    }

    public void addSeriesFlag() {
        this._flags |= 2;
    }

    public boolean isFull() {
        return this._flags == 2046;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FillType) {
            return this._flags == ((FillType)obj).getFlags();
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int flag = 1;
        block12: for (int i = 0; i < 32; ++i) {
            if ((this._flags & (flag <<= 1)) == 0) continue;
            switch (flag) {
                case 2: {
                    buf.append("Series|");
                    continue block12;
                }
                case 4: {
                    buf.append("GrowthTrend|");
                    continue block12;
                }
                case 8: {
                    buf.append("LinearTrend|");
                    continue block12;
                }
                case 16: {
                    buf.append("Days|");
                    continue block12;
                }
                case 32: {
                    buf.append("Weekdays|");
                    continue block12;
                }
                case 64: {
                    buf.append("Months|");
                    continue block12;
                }
                case 128: {
                    buf.append("Years|");
                    continue block12;
                }
                case 256: {
                    buf.append("Copy|");
                    continue block12;
                }
                case 512: {
                    buf.append("Formats|");
                    continue block12;
                }
                case 1024: {
                    buf.append("Values|");
                    continue block12;
                }
            }
        }
        return buf.toString();
    }

    public boolean isNumberType() {
        return this.touchFlag(12);
    }

    public boolean isDateType() {
        return this.touchFlag(240);
    }

    public boolean isSerialType() {
        return this.touchFlag(2);
    }

    public FillType getSelectedType() {
        if (this.isSerialType() && this._statCount != 1) {
            return SERIES;
        }
        if (this.isNumberType()) {
            if (this.isDateType()) {
                return SERIES;
            }
            return GROWTHTREND;
        }
        if (this.isDateType()) {
            return DAYS;
        }
        return COPY;
    }
}

