/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.undo.UndoException;

public class SheetAction_AttributeSpan
extends SheetAction {
    private ShareStyleAttributes _ssa;
    private Integer _length;
    private Boolean _visible;
    private boolean _bRow;
    private Integer _groupLevel;
    private Boolean _collapse;

    public SheetAction_AttributeSpan(Range rg, ShareStyleAttributes ssa, Integer length, Boolean visible, Integer groupLevel, Boolean collapse, boolean bRow) {
        super(rg, (ssa != null ? SheetChangeEvent.Changed_Style : 0L) | (length != null || visible != null ? SheetChangeEvent.Changed_Resize : 0L) | (groupLevel != null ? SheetChangeEvent.Changed_GroupLevel : 0L));
        this._ssa = ssa;
        this._length = length;
        this._visible = visible;
        this._bRow = bRow;
        this._groupLevel = groupLevel;
        this._collapse = collapse;
    }

    @Override
    public void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        SortedSpanArray changedSpans;
        SortedSpanArray sortedSpanArray = state != null ? new SortedSpanArray(this._bRow ? 1048575 : 65535) : (changedSpans = null);
        if (this._bRow && cb.isRow()) {
            sheet.getRowSpans().setSpanAttribute(cb.getRowSpan(), this._ssa, this._length, this._visible, this._groupLevel, this._collapse, changedSpans);
        } else if (!this._bRow && cb.isCol()) {
            sheet.getColSpans().setSpanAttribute(cb.getColSpan(), this._ssa, this._length, this._visible, this._groupLevel, this._collapse, changedSpans);
        }
        this.URStore(state, this._bRow ? "ROW_SSA" : "COL_SSA", changedSpans);
    }

    @Override
    public void undo() throws UndoException {
        super.undo();
        for (int i = 0; i < this._rg.getRangeSheets().size(); ++i) {
            Sheet sheet = this._rg.getRangeSheets().getSheet(i);
            if (!MiscUtil.isExecutedBook(sheet.getBook())) continue;
            ExecutorUtil.calcDisplayValue(sheet, sheet);
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray SSAs;
        ShareStyleAttributes sheetSSA;
        if (cb.isWholeSheet() && (sheetSSA = (ShareStyleAttributes)state.get("SHEET_SSA")) != null) {
            sheet.setSSA(sheetSSA);
        }
        if ((SSAs = (ObjectArray)state.get("CELL_SSA")) != null) {
            ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
            for (int i = clls.size() - 1; i >= 0; --i) {
                ((Cell)clls.get(i)).setSSA((ShareStyleAttributes)SSAs.get(i));
            }
        }
        sheet.getRowSpans().setSpans((SortedSpanArray)state.get("ROW_SSA"));
        sheet.getColSpans().setSpans((SortedSpanArray)state.get("COL_SSA"));
        Borders bdrs = (Borders)state.get("BDR");
        if (bdrs != null) {
            sheet.getBorders().set(bdrs);
        }
    }

    @Override
    protected CellBlock getInvalidateBlock(int index) {
        CellBlock invalidRect = Range._invalidRect;
        invalidRect.copyFrom(this._rg.getBlock(index));
        if (this._bRow) {
            invalidRect.setCol(0);
            invalidRect.setCol2(65535);
        } else {
            invalidRect.setRow(0);
            invalidRect.setRow2(1048575);
        }
        return invalidRect;
    }

    @Override
    public String getPresentationName() {
        return "\u8bbe\u7f6e\u5c5e\u6027" + super.getPresentationName();
    }
}

