/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;

public class SheetAction_Named
extends SheetAction {
    private NamedObjectNode _no;
    private Expr _expr;

    public SheetAction_Named(Range rg, NamedObjectNode no, Expr expr) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Named);
        this._no = no;
        this._expr = expr;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        if (this._rg._sheets.getSheet(0) != sheet) {
            return;
        }
        boolean change = false;
        if (this._expr == null) {
            change = true;
            this._expr = NamedObjectNode.getUndefinedExpr();
        } else {
            ExprContext ctx = sheet.getDeps().getExprContext();
            String refersTo = this._expr.decode(ctx, sheet.getParserHelper());
            if (!refersTo.equals(this._no.getRefersTo())) {
                change = true;
            }
        }
        if (change) {
            this._no.queue();
            Expr old = this._no.getExpr();
            this._no.setExpr(this._expr);
            if (state != null) {
                state.setData("NAMED_OBJ", this._no);
                state.setData("NAMED_OBJ_EXPR", old);
            }
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        NamedObjectNode no = (NamedObjectNode)state.get("NAMED_OBJ");
        if (no != null) {
            no.setExpr((Expr)state.get("NAMED_OBJ_EXPR"));
            no.queue();
        }
    }

    @Override
    public String getPresentationName() {
        return "\u547d\u540d" + super.getPresentationName();
    }
}

