/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed;

import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.HotSpot;
import java.awt.Shape;

public abstract class RectEmbedment
extends EmbedObject {
    protected HotSpot[] _hotSpots;

    public RectEmbedment(Sheet sheet) {
        super(sheet);
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getY() && y < this.getY() + this.getHeight();
    }

    @Override
    public HotSpot[] getHotSpots() {
        if (this._hotSpots == null) {
            this._hotSpots = new HotSpot[8];
            this._hotSpots[0] = new HotSpot(this, 1);
            this._hotSpots[1] = new HotSpot(this, 7);
            this._hotSpots[2] = new HotSpot(this, 2);
            this._hotSpots[3] = new HotSpot(this, 6);
            this._hotSpots[4] = new HotSpot(this, 4);
            this._hotSpots[5] = new HotSpot(this, 8);
            this._hotSpots[6] = new HotSpot(this, 3);
            this._hotSpots[7] = new HotSpot(this, 5);
            this.updateHotSpots();
        }
        return this._hotSpots;
    }

    @Override
    public Shape getOutLine(HotSpot hs, int dx, int dy) {
        return EmbedMath.calcOutLineRect(hs == null ? -1 : hs.getType(), this._x, this._y, this._width, this._height, dx, dy);
    }

    @Override
    protected void boundsUpdated(int oldx, int oldy, int oldw, int oldh) {
        this.updateHotSpots();
    }

    protected void updateHotSpots() {
        if (this._hotSpots != null) {
            int x = this._x;
            int y = this._y;
            int x2 = (2 * this._x + this._width) / 2;
            int y2 = (2 * this._y + this._height) / 2;
            int x3 = this._x + this._width;
            int y3 = this._y + this._height;
            this._hotSpots[0].setLocation(x, y);
            this._hotSpots[1].setLocation(x2, y);
            this._hotSpots[2].setLocation(x3, y);
            this._hotSpots[3].setLocation(x3, y2);
            this._hotSpots[4].setLocation(x3, y3);
            this._hotSpots[5].setLocation(x2, y3);
            this._hotSpots[6].setLocation(x, y3);
            this._hotSpots[7].setLocation(x, y2);
        }
    }
}

