/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.IChartCalculator;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.HashMap;

public class ChartCellCalculator
implements IChartCalculator {
    protected Sheet sheet;
    protected ChartDataNode dataNode;
    protected HashMap<String, Object> resultMap = null;
    protected ChartResultData resultData = null;

    public ChartCellCalculator(Sheet sheet, ChartDataNode chartNode) {
        this.sheet = sheet;
        this.dataNode = chartNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChartResultData calc() {
        ExprContext ctx = this.sheet.getDeps().getExprContext();
        Expr dataExpr = this.dataNode.getExpr();
        ICalculable calcOwner = this.dataNode.getCalcOwner(dataExpr);
        if (calcOwner != null) {
            ExtDataSetManager dm = this.sheet.getBook().getDataSetManager();
            dm.resetCurrent();
            boolean createCell = false;
            if (calcOwner instanceof Cell) {
                ExtProps ep = ((Cell)calcOwner).getExtProps(false);
                if (ep != null) {
                    ep.setCurrentGroup();
                }
            } else {
                createCell = true;
                Cell cll = this.sheet.getCell(1048574, 65534, true);
                cll.getExtProps(true).calcExtendProps();
                calcOwner = cll;
            }
            dm.resumeCurrent();
            ctx.pushExprOwner(calcOwner);
            try {
                Object ret;
                this.resultData = new ChartResultData();
                boolean extensible = ctx.isTraceMode();
                int dirty = this.dataNode.getDirty();
                Expr[] exprs = this.dataNode.getExprs();
                if ((dirty & 1) != 0) {
                    Object data = this.calcExpr(ctx, calcOwner, dataExpr, 1);
                    this.resultData.setData(data);
                    this.resultData.setDataExpr(dataExpr);
                    if (extensible) {
                        this.resultData.setDataExpr((Expr)ctx.getTempRet());
                    }
                }
                if ((dirty & 4) != 0) {
                    Expr seriesExpr = exprs[1];
                    Object seriesKeys = this.calcExpr(ctx, calcOwner, seriesExpr, 4);
                    this.resultData.setSeries(seriesKeys);
                    this.resultData.setSeriesExpr(seriesExpr);
                    if (extensible) {
                        this.resultData.setSeriesExpr((Expr)ctx.getTempRet());
                    }
                }
                if ((dirty & 2) != 0) {
                    Expr groupExpr = exprs[0];
                    Object groupKeys = this.calcExpr(ctx, calcOwner, groupExpr, 2);
                    this.resultData.setGroups((String[])groupKeys);
                    this.resultData.setGroupExpr(groupExpr);
                    if (extensible) {
                        this.resultData.setGroupExpr((Expr)ctx.getTempRet());
                    }
                }
                if ((dirty & 8) != 0) {
                    Expr chartTitleExpr = exprs[2];
                    ret = this.calcExpr(ctx, calcOwner, chartTitleExpr, 8);
                    String chartTitle = ret == null ? "" : (String)ret;
                    this.resultData.setChartTitle(chartTitle);
                    this.resultData.setChartTitleExpr(chartTitleExpr);
                    if (extensible) {
                        this.resultData.setChartTitleExpr((Expr)ctx.getTempRet());
                    }
                }
                if ((dirty & 0x10) != 0) {
                    Expr categoryAxisTitleExpr = exprs[3];
                    ret = this.calcExpr(ctx, calcOwner, categoryAxisTitleExpr, 16);
                    String categoryAxisTitle = ret == null ? "" : (String)ret;
                    this.resultData.setCategoryAxisTitle(categoryAxisTitle);
                    this.resultData.setCategoryAxisTitleExpr(categoryAxisTitleExpr);
                    if (extensible) {
                        this.resultData.setCategoryAxisTitleExpr((Expr)ctx.getTempRet());
                    }
                }
                if ((dirty & 0x20) != 0) {
                    Expr valueAxisTitleExpr = exprs[4];
                    ret = this.calcExpr(ctx, calcOwner, valueAxisTitleExpr, 32);
                    String valueAxisTitle = ret == null ? "" : (String)ret;
                    this.resultData.setValueAxisTitle(valueAxisTitle);
                    this.resultData.setValueAxisTitleExpr(valueAxisTitleExpr);
                    if (extensible) {
                        this.resultData.setValueAxisTitleExpr((Expr)ctx.getTempRet());
                    }
                }
            }
            finally {
                ctx.popExprOwner();
                if (createCell) {
                    this.sheet.getRows().remove(1048574);
                    this.sheet.getCols().remove(65534);
                }
            }
        }
        return this.resultData;
    }

    private Object calcExpr(ExprContext ctx, ICalculable calcOwner, Expr expr, int flag) {
        if (expr == null) {
            return null;
        }
        Object ret = null;
        SortedCellBlockArray aRange = null;
        Expr extExpr = this.sheet.getExtExpr(null, expr, calcOwner);
        if (extExpr != null) {
            expr = extExpr;
        }
        Variant var = expr.execute(ctx, calcOwner);
        Object value = var.getValue();
        IExprBuffer buffer = ctx.getBuffer();
        if (value instanceof CellBlockNode) {
            aRange = new SortedCellBlockArray();
            aRange.insert(((CellBlock)value).clone());
        } else if (value instanceof Variant[]) {
            Variant[] array = (Variant[])value;
            if (array.length > 0) {
                Variant first = array[0];
                value = first.getValue();
                if (first.isReferences() && value instanceof CellBlockNode || first.isArray() && ((Variant[])value)[0].getValue() instanceof CellBlockNode) {
                    aRange = new SortedCellBlockArray();
                    for (int i = 0; i < array.length; ++i) {
                        Variant v = array[i];
                        value = v.getValue();
                        if (v.isReferences() && value instanceof CellBlockNode) {
                            aRange.insert(value);
                            continue;
                        }
                        if (!v.isArray() || !(((Variant[])value)[0].getValue() instanceof CellBlockNode)) continue;
                        Variant[] varBlocks = (Variant[])value;
                        for (int j = 0; j < varBlocks.length; ++j) {
                            aRange.insert(varBlocks[j].getValue());
                        }
                    }
                } else if (!first.isObject()) {
                    ret = this.getDataFromArray(array, flag);
                } else if (value instanceof ExtGroup) {
                    ObjectArray oa = buffer.getObjectArray(array.length << 3);
                    for (int i = 0; i < array.length; ++i) {
                        ExtGroup group = (ExtGroup)array[i].getValue();
                        oa.appendAll(group.getValues(), group.getValueFrom(), group.getValueTo());
                    }
                    Object[] varArray = new Variant[oa.size()];
                    oa.toArray(varArray, 0);
                    ret = this.getDataFromArray((Variant[])varArray, flag);
                    buffer.recycleArray(oa);
                }
            }
        } else {
            Object[] varArray;
            boolean recycle = false;
            if (value instanceof ExtGroup) {
                ExtGroup group = (ExtGroup)value;
                varArray = new Variant[group.size()];
                KDToolkit.arraycopy((Object[])group.getValues(), (int)group.getFrom(), (Object[])varArray, (int)0, (int)group.size());
            } else {
                varArray = buffer.getOneVariantArray(var);
                recycle = true;
            }
            ret = this.getDataFromArray((Variant[])varArray, flag);
            if (recycle) {
                buffer.recycleArray((Variant[])varArray);
            }
        }
        if (aRange != null) {
            ret = this.getDataFromRange(aRange, flag);
        }
        return ret;
    }

    private Object getDataFromArray(Variant[] array, int flag) {
        Object ret;
        double[][] data = (double[][])this.resultData.getData();
        switch (flag) {
            case 1: {
                ret = this.getDataFromArray(array);
                break;
            }
            case 2: {
                ret = this.getKeysFromArray(array, data[0].length);
                break;
            }
            case 4: {
                int size = this.dataNode.isSerialByCol() ? data[0].length : data.length;
                ret = this.getKeysFromArray(array, size);
                break;
            }
            default: {
                ret = array[0].getVariant().toString();
            }
        }
        return ret;
    }

    private Object getDataFromRange(SortedCellBlockArray range, int flag) {
        Object ret = null;
        double[][] data = (double[][])this.resultData.getData();
        switch (flag) {
            case 1: {
                ret = this.getDataFromRange(range);
                break;
            }
            case 2: {
                if (data == null) break;
                ret = this.getKeysFromRange(range, data[0].length);
                break;
            }
            case 4: {
                ret = this.getKeysFromRange(range, Integer.MAX_VALUE);
                break;
            }
            default: {
                CellBlock cb = range.getBlock(0);
                Sheet.ICellsIterator ci = this.sheet.getCellsIterator(cb, false, false);
                ret = ci.hasNext() ? (Object)ci.next().getValue().getVariant().toString() : (Object)"";
            }
        }
        return ret;
    }

    private double[][] getDataFromArray(Variant[] varArray) {
        double[][] aadb;
        Variant var = varArray[0];
        if (var.isArray()) {
            int dim2 = ((Variant[])var.getValue()).length;
            aadb = new double[varArray.length][dim2];
            for (int i = 0; i < varArray.length; ++i) {
                double[] adb = aadb[i];
                Variant[] vars = (Variant[])varArray[i].getValue();
                for (int j = 0; j < dim2; ++j) {
                    try {
                        adb[j] = vars[j].doubleValue();
                        continue;
                    }
                    catch (SyntaxErrorException syntaxErrorException) {
                        // empty catch block
                    }
                }
            }
        } else {
            aadb = new double[1][varArray.length];
            double[] adb = aadb[0];
            for (int i = 0; i < varArray.length; ++i) {
                try {
                    adb[i] = varArray[i].doubleValue();
                    continue;
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    // empty catch block
                }
            }
        }
        return aadb;
    }

    private String[] getKeysFromRange(SortedCellBlockArray range, int maxSize) {
        ObjectArray a = new ObjectArray();
        int i = 0;
        int size = range.size();
        block0: for (int b = 0; b < size; ++b) {
            CellBlock cb = range.getBlock(b);
            Sheet.ICellsIterator ci = cb instanceof CellBlockNode ? ((CellBlockNode)cb).getSheet().getCellsIterator(cb, false, false) : this.sheet.getCellsIterator(cb, false, false);
            while (ci.hasNext()) {
                a.append(ci.next().getText());
                if (++i < maxSize) continue;
                break block0;
            }
        }
        Object[] keys = new String[a.size()];
        a.toArray(keys, 0);
        return keys;
    }

    private String[] getKeysFromArray(Variant[] varArray, int size) {
        String[] aStr = new String[Math.min(size, varArray.length)];
        for (int i = 0; i < aStr.length; ++i) {
            aStr[i] = varArray[i].toString();
        }
        return aStr;
    }

    private double[][] getDataFromRange(SortedCellBlockArray range) {
        double[][] data = this._getContractBlocksData(range);
        if (data != null) {
            return data;
        }
        int rows = 0;
        int cols = 0;
        int blocks = range.size();
        for (int i = 0; i < blocks; ++i) {
            CellBlock block = range.getBlock(i);
            if (this.dataNode.isSerialByCol()) {
                rows = Math.max(rows, block.getHeight());
                cols += block.getWidth();
                continue;
            }
            cols = Math.max(cols, block.getWidth());
            rows += block.getHeight();
        }
        int maxSize = 100;
        data = this.dataNode.isSerialByCol() ? new double[Math.min(cols, maxSize)][Math.min(rows, maxSize)] : new double[Math.min(rows, maxSize)][Math.min(cols, maxSize)];
        try {
            int rowStart = 0;
            int colStart = 0;
            for (int i = 0; i < blocks; ++i) {
                CellBlock block = range.getBlock(i);
                int r2 = block.getRow2() + 1;
                int c1 = block.getCol();
                int c2 = block.getCol2() + 1;
                int row = rowStart;
                int r = block.getRow();
                while (r < r2) {
                    Row rowObj = this.sheet.getRow(r, false);
                    if (rowObj != null) {
                        int col = colStart;
                        int c = c1;
                        while (c < c2) {
                            Cell cll = rowObj.getCell(c, false);
                            if (cll != null) {
                                double df;
                                try {
                                    df = cll.getValue().doubleValue();
                                }
                                catch (Exception e) {
                                    df = 0.0;
                                }
                                if (this.dataNode.isSerialByCol()) {
                                    data[col][row] = df;
                                } else {
                                    data[row][col] = df;
                                }
                            }
                            ++c;
                            ++col;
                        }
                    }
                    ++r;
                    ++row;
                }
                if (this.dataNode.isSerialByCol()) {
                    colStart += block.getWidth();
                    continue;
                }
                rowStart += block.getHeight();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private double[][] _getContractBlocksData(SortedCellBlockArray range) {
        int blockRows;
        int blockCols;
        int dataWidth;
        int dataHeight;
        CellBlockNode[][] blocks;
        block17: {
            blocks = null;
            dataHeight = 0;
            dataWidth = 0;
            blockCols = 1;
            blockRows = 1;
            int size = range.size();
            if (size == 1) {
                CellBlockNode block = (CellBlockNode)range.getBlock(0);
                dataHeight = block.getHeight();
                dataWidth = block.getWidth();
                blocks = new CellBlockNode[][]{{block}};
            } else {
                CellBlock firstBlock = range.getBlock(0);
                dataWidth += firstBlock.getWidth();
                for (int i = 1; i < size; ++i) {
                    CellBlock block = range.getBlock(i);
                    if (block.equalsRow(firstBlock)) {
                        ++blockCols;
                        dataWidth += block.getWidth();
                        continue;
                    }
                    if (!block.intersectRow(firstBlock)) break;
                    break block17;
                }
                if (blockCols <= 1 || size % blockCols == 0) {
                    blockRows = size / blockCols;
                    blocks = new CellBlockNode[blockRows][blockCols];
                    int i = 0;
                    block3: for (int r = 0; r < blockRows; ++r) {
                        CellBlockNode[] line = blocks[r];
                        firstBlock = range.getBlock(i++);
                        line[0] = firstBlock;
                        dataHeight += firstBlock.getHeight();
                        int w = firstBlock.getWidth();
                        for (int c = 1; c < blockCols; ++c) {
                            CellBlock block;
                            if (!(block = range.getBlock(i++)).equalsRow(firstBlock)) {
                                blocks = null;
                                break block3;
                            }
                            line[c] = block;
                            w += block.getWidth();
                        }
                        if (w == dataWidth) continue;
                        blocks = null;
                        break;
                    }
                }
            }
        }
        double[][] datas = null;
        if (blocks != null) {
            int maxSize = 10000;
            datas = this.dataNode.isSerialByCol() ? new double[Math.min(dataWidth, maxSize)][Math.min(dataHeight, maxSize)] : new double[Math.min(dataHeight, maxSize)][Math.min(dataWidth, maxSize)];
            try {
                boolean isFillNullWithZero = this.dataNode.isFillNullWithZero();
                int i = 0;
                int j = 0;
                for (int rSrc = 0; rSrc < blockRows; ++rSrc) {
                    CellBlockNode[] line = blocks[rSrc];
                    if (this.dataNode.isSerialByCol()) {
                        i = 0;
                    } else {
                        j = 0;
                    }
                    for (int cSrc = 0; cSrc < blockCols; ++cSrc) {
                        CellBlockNode cb = line[cSrc];
                        Variant[][] cbData = ExcelFuncProvider.collectD2Numbers(cb.getVarThis(), true, isFillNullWithZero);
                        this._copyBlockData(cbData, datas, i, j, !this.dataNode.isSerialByCol());
                        int step = cb.getWidth();
                        if (this.dataNode.isSerialByCol()) {
                            i += step;
                            continue;
                        }
                        j += step;
                    }
                    int step = line[0].getHeight();
                    if (this.dataNode.isSerialByCol()) {
                        j += step;
                        continue;
                    }
                    i += step;
                }
            }
            catch (SyntaxErrorException e) {
                datas = null;
            }
        }
        return datas;
    }

    private void _copyBlockData(Variant[][] src, double[][] dst, int dstRow, int dstCol, boolean byRow) throws SyntaxErrorException {
        int srcRows = src.length;
        int srcCols = src[0].length;
        for (int r = 0; r < srcRows; ++r) {
            int c;
            Variant[] srcLine = src[r];
            if (byRow) {
                double[] dstLine = dst[dstRow + r];
                int col = dstCol;
                for (c = 0; c < srcCols; ++c) {
                    dstLine[col] = Variant.emptyVariant.equals(srcLine[c]) ? Double.NaN : srcLine[c].doubleValue();
                    ++col;
                }
                continue;
            }
            int col = dstCol + r;
            int i = dstRow;
            for (c = 0; c < srcCols; ++c) {
                dst[i][col] = Variant.emptyVariant.equals(srcLine[c]) ? Double.NaN : srcLine[c].doubleValue();
                ++i;
            }
        }
    }
}

